@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Api error base.
 * @property code The error code.
 * @property message The error message.
 * @property target The target of the particular error.
 */
public data class ApiErrorBaseResponse(
    public val code: String? = null,
    public val message: String? = null,
    public val target: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.ApiErrorBaseResponse):
            ApiErrorBaseResponse = ApiErrorBaseResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
        )
    }
}
