@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes a data disk.
 * @property caching Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**
 * @property createOption Specifies how the virtual machine should be created. Possible values are: **Attach.** This value is used when you are using a specialized disk to create the virtual machine. **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you should also use the imageReference element described above. If you are using a marketplace image, you should also use the plan element previously described.
 * @property deleteOption Specifies whether data disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If this value is used, the data disk is deleted when VM is deleted. **Detach.** If this value is used, the data disk is retained after VM is deleted. The default value is set to **Detach**.
 * @property detachOption Specifies the detach behavior to be used while detaching a disk or which is already in the process of detachment from the virtual machine. Supported values: **ForceDetach.** detachOption: **ForceDetach** is applicable only for managed data disks. If a previous detachment attempt of the data disk did not complete due to an unexpected failure from the virtual machine and the disk is still not released then use force-detach as a last resort option to detach the disk forcibly from the VM. All writes might not have been flushed when using this detach behavior. **This feature is still in preview** mode and is not supported for VirtualMachineScaleSet. To force-detach a data disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
 * @property diskIOPSReadWrite Specifies the Read-Write IOPS for the managed disk when StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be updated only via updates to the VirtualMachine Scale Set.
 * @property diskMBpsReadWrite Specifies the bandwidth in MB per second for the managed disk when StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be updated only via updates to the VirtualMachine Scale Set.
 * @property diskSizeGB Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
 * @property image The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
 * @property lun Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
 * @property managedDisk The managed disk parameters.
 * @property name The disk name.
 * @property toBeDetached Specifies whether the data disk is in process of detachment from the VirtualMachine/VirtualMachineScaleset
 * @property vhd The virtual hard disk.
 * @property writeAcceleratorEnabled Specifies whether writeAccelerator should be enabled or disabled on the disk.
 */
public data class DataDiskResponse(
    public val caching: String? = null,
    public val createOption: String,
    public val deleteOption: String? = null,
    public val detachOption: String? = null,
    public val diskIOPSReadWrite: Double,
    public val diskMBpsReadWrite: Double,
    public val diskSizeGB: Int? = null,
    public val image: VirtualHardDiskResponse? = null,
    public val lun: Int,
    public val managedDisk: ManagedDiskParametersResponse? = null,
    public val name: String? = null,
    public val toBeDetached: Boolean? = null,
    public val vhd: VirtualHardDiskResponse? = null,
    public val writeAcceleratorEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.DataDiskResponse):
            DataDiskResponse = DataDiskResponse(
            caching = javaType.caching().map({ args0 -> args0 }).orElse(null),
            createOption = javaType.createOption(),
            deleteOption = javaType.deleteOption().map({ args0 -> args0 }).orElse(null),
            detachOption = javaType.detachOption().map({ args0 -> args0 }).orElse(null),
            diskIOPSReadWrite = javaType.diskIOPSReadWrite(),
            diskMBpsReadWrite = javaType.diskMBpsReadWrite(),
            diskSizeGB = javaType.diskSizeGB().map({ args0 -> args0 }).orElse(null),
            image = javaType.image().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualHardDiskResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lun = javaType.lun(),
            managedDisk = javaType.managedDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ManagedDiskParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            toBeDetached = javaType.toBeDetached().map({ args0 -> args0 }).orElse(null),
            vhd = javaType.vhd().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.VirtualHardDiskResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            writeAcceleratorEnabled = javaType.writeAcceleratorEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
