@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Disk Restore Point details.
 * @property encryption Encryption at rest settings for disk restore point. It is an optional property that can be specified in the input while creating a restore point.
 * @property id Resource Id
 * @property sourceDiskRestorePoint Resource Id of the source disk restore point.
 */
public data class DiskRestorePointAttributesResponse(
    public val encryption: RestorePointEncryptionResponse? = null,
    public val id: String,
    public val sourceDiskRestorePoint: ApiEntityReferenceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.DiskRestorePointAttributesResponse):
            DiskRestorePointAttributesResponse = DiskRestorePointAttributesResponse(
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.RestorePointEncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            sourceDiskRestorePoint = javaType.sourceDiskRestorePoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.ApiEntityReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
