@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
 * @property name The sku name.
 * @property tier The sku tier.
 */
public data class DiskSkuResponse(
    public val name: String? = null,
    public val tier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.DiskSkuResponse):
            DiskSkuResponse = DiskSkuResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier(),
        )
    }
}
