@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a cloud service Extension.
 * @property name The name of the extension.
 * @property properties Extension Properties.
 */
public data class ExtensionResponse(
    public val name: String? = null,
    public val properties: CloudServiceExtensionPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.ExtensionResponse):
            ExtensionResponse = ExtensionResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.CloudServiceExtensionPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
