@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The definition of a parameter that can be passed to a custom action of a Gallery Application Version.
 * @property defaultValue The default value of the parameter.  Only applies to string types
 * @property description A description to help users understand what this parameter means
 * @property name The name of the custom action.  Must be unique within the Gallery Application Version.
 * @property required Indicates whether this parameter must be passed when running the custom action.
 * @property type Specifies the type of the custom action parameter. Possible values are: String, ConfigurationDataBlob or LogOutputBlob
 */
public data class GalleryApplicationCustomActionParameterResponse(
    public val defaultValue: String? = null,
    public val description: String? = null,
    public val name: String,
    public val required: Boolean? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GalleryApplicationCustomActionParameterResponse):
            GalleryApplicationCustomActionParameterResponse =
            GalleryApplicationCustomActionParameterResponse(
                defaultValue = javaType.defaultValue().map({ args0 -> args0 }).orElse(null),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                required = javaType.required().map({ args0 -> args0 }).orElse(null),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
            )
    }
}
