@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 * This is the safety profile of the Gallery Image Version.
 * @property allowDeletionOfReplicatedLocations Indicates whether or not removing this Gallery Image Version from replicated regions is allowed.
 * @property policyViolations A list of Policy Violations that have been reported for this Gallery Image Version.
 * @property reportedForPolicyViolation Indicates whether this image has been reported as violating Microsoft's policies.
 */
public data class GalleryImageVersionSafetyProfileResponse(
    public val allowDeletionOfReplicatedLocations: Boolean? = null,
    public val policyViolations: List<PolicyViolationResponse>,
    public val reportedForPolicyViolation: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GalleryImageVersionSafetyProfileResponse):
            GalleryImageVersionSafetyProfileResponse = GalleryImageVersionSafetyProfileResponse(
            allowDeletionOfReplicatedLocations = javaType.allowDeletionOfReplicatedLocations().map({ args0 ->
                args0
            }).orElse(null),
            policyViolations = javaType.policyViolations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.PolicyViolationResponse.Companion.toKotlin(args0)
                })
            }),
            reportedForPolicyViolation = javaType.reportedForPolicyViolation(),
        )
    }
}
