@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property encryption Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
 * @property extendedLocation The name of the extended location.
 * @property extendedLocationReplicaCount The number of replicas of the Image Version to be created per extended location. This property is updatable.
 * @property name The name of the region.
 * @property storageAccountType Specifies the storage account type to be used to store the image. This property is not updatable.
 */
public data class GalleryTargetExtendedLocationResponse(
    public val encryption: EncryptionImagesResponse? = null,
    public val extendedLocation: GalleryExtendedLocationResponse? = null,
    public val extendedLocationReplicaCount: Int? = null,
    public val name: String? = null,
    public val storageAccountType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GalleryTargetExtendedLocationResponse):
            GalleryTargetExtendedLocationResponse = GalleryTargetExtendedLocationResponse(
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.EncryptionImagesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.GalleryExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            extendedLocationReplicaCount = javaType.extendedLocationReplicaCount().map({ args0 ->
                args0
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            storageAccountType = javaType.storageAccountType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
