@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to an availability set at creation time. An existing VM cannot be added to an availability set.
 * @property id Resource Id
 * @property location Resource location
 * @property name Resource name
 * @property platformFaultDomainCount Fault Domain count.
 * @property platformUpdateDomainCount Update Domain count.
 * @property proximityPlacementGroup Specifies information about the proximity placement group that the availability set should be assigned to. Minimum api-version: 2018-04-01.
 * @property sku Sku of the availability set, only name is required to be set. See AvailabilitySetSkuTypes for possible set of values. Use 'Aligned' for virtual machines with managed disks and 'Classic' for virtual machines with unmanaged disks. Default value is 'Classic'.
 * @property statuses The resource status information.
 * @property tags Resource tags
 * @property type Resource type
 * @property virtualMachines A list of references to all virtual machines in the availability set.
 */
public data class GetAvailabilitySetResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val platformFaultDomainCount: Int? = null,
    public val platformUpdateDomainCount: Int? = null,
    public val proximityPlacementGroup: SubResourceResponse? = null,
    public val sku: SkuResponse? = null,
    public val statuses: List<InstanceViewStatusResponse>,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualMachines: List<SubResourceResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetAvailabilitySetResult):
            GetAvailabilitySetResult = GetAvailabilitySetResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            platformFaultDomainCount = javaType.platformFaultDomainCount().map({ args0 -> args0 }).orElse(null),
            platformUpdateDomainCount = javaType.platformUpdateDomainCount().map({ args0 ->
                args0
            }).orElse(null),
            proximityPlacementGroup = javaType.proximityPlacementGroup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualMachines = javaType.virtualMachines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
