@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Specifies information about the gallery image version that you want to create or update.
 * @property id Resource Id
 * @property location Resource location
 * @property name Resource name
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property publishingProfile The publishing profile of a gallery image Version.
 * @property replicationStatus This is the replication status of the gallery image version.
 * @property safetyProfile This is the safety profile of the Gallery Image Version.
 * @property storageProfile This is the storage profile of a Gallery Image Version.
 * @property tags Resource tags
 * @property type Resource type
 */
public data class GetGalleryImageVersionResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val publishingProfile: GalleryImageVersionPublishingProfileResponse? = null,
    public val replicationStatus: ReplicationStatusResponse,
    public val safetyProfile: GalleryImageVersionSafetyProfileResponse? = null,
    public val storageProfile: GalleryImageVersionStorageProfileResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GetGalleryImageVersionResult):
            GetGalleryImageVersionResult = GetGalleryImageVersionResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            publishingProfile = javaType.publishingProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.GalleryImageVersionPublishingProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            replicationStatus = javaType.replicationStatus().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.ReplicationStatusResponse.Companion.toKotlin(args0)
            }),
            safetyProfile = javaType.safetyProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.GalleryImageVersionSafetyProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageProfile = javaType.storageProfile().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.GalleryImageVersionStorageProfileResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
