@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes a data disk.
 * @property blobUri The Virtual Hard Disk.
 * @property caching Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium storage.**
 * @property diskEncryptionSet Specifies the customer managed disk encryption set resource id for the managed image disk.
 * @property diskSizeGB Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. This value cannot be larger than 1023 GB.
 * @property lun Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
 * @property managedDisk The managedDisk.
 * @property snapshot The snapshot.
 * @property storageAccountType Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
 */
public data class ImageDataDiskResponse(
    public val blobUri: String? = null,
    public val caching: String? = null,
    public val diskEncryptionSet: DiskEncryptionSetParametersResponse? = null,
    public val diskSizeGB: Int? = null,
    public val lun: Int,
    public val managedDisk: SubResourceResponse? = null,
    public val snapshot: SubResourceResponse? = null,
    public val storageAccountType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.ImageDataDiskResponse):
            ImageDataDiskResponse = ImageDataDiskResponse(
            blobUri = javaType.blobUri().map({ args0 -> args0 }).orElse(null),
            caching = javaType.caching().map({ args0 -> args0 }).orElse(null),
            diskEncryptionSet = javaType.diskEncryptionSet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiskEncryptionSetParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            diskSizeGB = javaType.diskSizeGB().map({ args0 -> args0 }).orElse(null),
            lun = javaType.lun(),
            managedDisk = javaType.managedDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            snapshot = javaType.snapshot().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageAccountType = javaType.storageAccountType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
