@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The source image used for creating the disk.
 * @property communityGalleryImageId A relative uri containing a community Azure Compute Gallery image reference.
 * @property id A relative uri containing either a Platform Image Repository, user image, or Azure Compute Gallery image reference.
 * @property lun If the disk is created from an image's data disk, this is an index that indicates which of the data disks in the image to use. For OS disks, this field is null.
 * @property sharedGalleryImageId A relative uri containing a direct shared Azure Compute Gallery image reference.
 */
public data class ImageDiskReferenceResponse(
    public val communityGalleryImageId: String? = null,
    public val id: String? = null,
    public val lun: Int? = null,
    public val sharedGalleryImageId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.ImageDiskReferenceResponse):
            ImageDiskReferenceResponse = ImageDiskReferenceResponse(
            communityGalleryImageId = javaType.communityGalleryImageId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            lun = javaType.lun().map({ args0 -> args0 }).orElse(null),
            sharedGalleryImageId = javaType.sharedGalleryImageId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
