@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same sku as the previous snapshot
 * @property name The sku name.
 * @property tier The sku tier.
 */
public data class SnapshotSkuResponse(
    public val name: String? = null,
    public val tier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.SnapshotSkuResponse):
            SnapshotSkuResponse = SnapshotSkuResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier(),
        )
    }
}
