@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property install Required. The path and arguments to install the gallery application. This is limited to 4096 characters.
 * @property remove Required. The path and arguments to remove the gallery application. This is limited to 4096 characters.
 * @property update Optional. The path and arguments to update the gallery application. If not present, then update operation will invoke remove command on the previous version and install command on the current version of the gallery application. This is limited to 4096 characters.
 */
public data class UserArtifactManageResponse(
    public val install: String,
    public val remove: String,
    public val update: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.UserArtifactManageResponse):
            UserArtifactManageResponse = UserArtifactManageResponse(
            install = javaType.install(),
            remove = javaType.remove(),
            update = javaType.update().map({ args0 -> args0 }).orElse(null),
        )
    }
}
