@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Additional settings for the VM app that contains the target package and config file name when it is deployed to target VM or VM scale set.
 * @property configFileName Optional. The name to assign the downloaded config file on the VM. This is limited to 4096 characters. If not specified, the config file will be named the Gallery Application name appended with "_config".
 * @property packageFileName Optional. The name to assign the downloaded package file on the VM. This is limited to 4096 characters. If not specified, the package file will be named the same as the Gallery Application name.
 */
public data class UserArtifactSettingsResponse(
    public val configFileName: String? = null,
    public val packageFileName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.UserArtifactSettingsResponse):
            UserArtifactSettingsResponse = UserArtifactSettingsResponse(
            configFileName = javaType.configFileName().map({ args0 -> args0 }).orElse(null),
            packageFileName = javaType.packageFileName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
