@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration
 * @property deleteOption Specify what happens to the public IP when the VM is deleted
 * @property dnsSettings The dns settings to be applied on the publicIP addresses .
 * @property idleTimeoutInMinutes The idle timeout of the public IP address.
 * @property ipTags The list of IP tags associated with the public IP address.
 * @property name The publicIP address configuration name.
 * @property publicIPAddressVersion Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
 * @property publicIPPrefix The PublicIPPrefix from which to allocate publicIP addresses.
 * @property sku Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
 */
public data class VirtualMachineScaleSetPublicIPAddressConfigurationResponse(
    public val deleteOption: String? = null,
    public val dnsSettings: VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse? =
        null,
    public val idleTimeoutInMinutes: Int? = null,
    public val ipTags: List<VirtualMachineScaleSetIpTagResponse>? = null,
    public val name: String,
    public val publicIPAddressVersion: String? = null,
    public val publicIPPrefix: SubResourceResponse? = null,
    public val sku: PublicIPAddressSkuResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.VirtualMachineScaleSetPublicIPAddressConfigurationResponse):
            VirtualMachineScaleSetPublicIPAddressConfigurationResponse =
            VirtualMachineScaleSetPublicIPAddressConfigurationResponse(
                deleteOption = javaType.deleteOption().map({ args0 -> args0 }).orElse(null),
                dnsSettings = javaType.dnsSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                idleTimeoutInMinutes = javaType.idleTimeoutInMinutes().map({ args0 -> args0 }).orElse(null),
                ipTags = javaType.ipTags().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineScaleSetIpTagResponse.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name(),
                publicIPAddressVersion = javaType.publicIPAddressVersion().map({ args0 -> args0 }).orElse(null),
                publicIPPrefix = javaType.publicIPPrefix().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sku = javaType.sku().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.compute.kotlin.outputs.PublicIPAddressSkuResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
