@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin

import com.pulumi.azurenative.confidentialledger.kotlin.outputs.LedgerPropertiesResponse
import com.pulumi.azurenative.confidentialledger.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.confidentialledger.kotlin.outputs.LedgerPropertiesResponse.Companion.toKotlin as ledgerPropertiesResponseToKotlin
import com.pulumi.azurenative.confidentialledger.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Ledger].
 */
@PulumiTagMarker
public class LedgerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LedgerArgs = LedgerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LedgerArgsBuilder.() -> Unit) {
        val builder = LedgerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Ledger {
        val builtJavaResource =
            com.pulumi.azurenative.confidentialledger.Ledger(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Ledger(builtJavaResource)
    }
}

/**
 * Confidential Ledger. Contains the properties of Confidential Ledger Resource.
 * Azure REST API version: 2022-05-13. Prior API version in Azure Native 1.x: 2020-12-01-preview.
 * Other available API versions: 2023-01-26-preview, 2023-06-28-preview.
 * ## Example Usage
 * ### ConfidentialLedgerCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ledger = new AzureNative.ConfidentialLedger.Ledger("ledger", new()
 *     {
 *         LedgerName = "DummyLedgerName",
 *         Location = "EastUS",
 *         Properties = new AzureNative.ConfidentialLedger.Inputs.LedgerPropertiesArgs
 *         {
 *             AadBasedSecurityPrincipals = new[]
 *             {
 *                 new AzureNative.ConfidentialLedger.Inputs.AADBasedSecurityPrincipalArgs
 *                 {
 *                     LedgerRoleName = "Administrator",
 *                     PrincipalId = "34621747-6fc8-4771-a2eb-72f31c461f2e",
 *                     TenantId = "bce123b9-2b7b-4975-8360-5ca0b9b1cd08",
 *                 },
 *             },
 *             CertBasedSecurityPrincipals = new[]
 *             {
 *                 new AzureNative.ConfidentialLedger.Inputs.CertBasedSecurityPrincipalArgs
 *                 {
 *                     Cert = "-----BEGIN CERTIFICATE-----MIIBsjCCATigAwIBAgIUZWIbyG79TniQLd2UxJuU74tqrKcwCgYIKoZIzj0EAwMwEDEOMAwGA1UEAwwFdXNlcjAwHhcNMjEwMzE2MTgwNjExWhcNMjIwMzE2MTgwNjExWjAQMQ4wDAYDVQQDDAV1c2VyMDB2MBAGByqGSM49AgEGBSuBBAAiA2IABBiWSo/j8EFit7aUMm5lF+lUmCu+IgfnpFD+7QMgLKtxRJ3aGSqgS/GpqcYVGddnODtSarNE/HyGKUFUolLPQ5ybHcouUk0kyfA7XMeSoUA4lBz63Wha8wmXo+NdBRo39qNTMFEwHQYDVR0OBBYEFPtuhrwgGjDFHeUUT4nGsXaZn69KMB8GA1UdIwQYMBaAFPtuhrwgGjDFHeUUT4nGsXaZn69KMA8GA1UdEwEB/wQFMAMBAf8wCgYIKoZIzj0EAwMDaAAwZQIxAOnozm2CyqRwSSQLls5r+mUHRGRyXHXwYtM4Dcst/VEZdmS9fqvHRCHbjUlO/+HNfgIwMWZ4FmsjD3wnPxONOm9YdVn/PRD7SsPRPbOjwBiE4EBGaHDsLjYAGDSGi7NJnSkA-----END CERTIFICATE-----",
 *                     LedgerRoleName = "Reader",
 *                 },
 *             },
 *             LedgerType = "Public",
 *         },
 *         ResourceGroupName = "DummyResourceGroupName",
 *         Tags =
 *         {
 *             { "additionalProps1", "additional properties" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/confidentialledger/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := confidentialledger.NewLedger(ctx, "ledger", &confidentialledger.LedgerArgs{
 * 			LedgerName: pulumi.String("DummyLedgerName"),
 * 			Location:   pulumi.String("EastUS"),
 * 			Properties: confidentialledger.LedgerPropertiesResponse{
 * 				AadBasedSecurityPrincipals: confidentialledger.AADBasedSecurityPrincipalArray{
 * 					&confidentialledger.AADBasedSecurityPrincipalArgs{
 * 						LedgerRoleName: pulumi.String("Administrator"),
 * 						PrincipalId:    pulumi.String("34621747-6fc8-4771-a2eb-72f31c461f2e"),
 * 						TenantId:       pulumi.String("bce123b9-2b7b-4975-8360-5ca0b9b1cd08"),
 * 					},
 * 				},
 * 				CertBasedSecurityPrincipals: confidentialledger.CertBasedSecurityPrincipalArray{
 * 					&confidentialledger.CertBasedSecurityPrincipalArgs{
 * 						Cert:           pulumi.String("-----BEGIN CERTIFICATE-----MIIBsjCCATigAwIBAgIUZWIbyG79TniQLd2UxJuU74tqrKcwCgYIKoZIzj0EAwMwEDEOMAwGA1UEAwwFdXNlcjAwHhcNMjEwMzE2MTgwNjExWhcNMjIwMzE2MTgwNjExWjAQMQ4wDAYDVQQDDAV1c2VyMDB2MBAGByqGSM49AgEGBSuBBAAiA2IABBiWSo/j8EFit7aUMm5lF+lUmCu+IgfnpFD+7QMgLKtxRJ3aGSqgS/GpqcYVGddnODtSarNE/HyGKUFUolLPQ5ybHcouUk0kyfA7XMeSoUA4lBz63Wha8wmXo+NdBRo39qNTMFEwHQYDVR0OBBYEFPtuhrwgGjDFHeUUT4nGsXaZn69KMB8GA1UdIwQYMBaAFPtuhrwgGjDFHeUUT4nGsXaZn69KMA8GA1UdEwEB/wQFMAMBAf8wCgYIKoZIzj0EAwMDaAAwZQIxAOnozm2CyqRwSSQLls5r+mUHRGRyXHXwYtM4Dcst/VEZdmS9fqvHRCHbjUlO/+HNfgIwMWZ4FmsjD3wnPxONOm9YdVn/PRD7SsPRPbOjwBiE4EBGaHDsLjYAGDSGi7NJnSkA-----END CERTIFICATE-----"),
 * 						LedgerRoleName: pulumi.String("Reader"),
 * 					},
 * 				},
 * 				LedgerType: pulumi.String("Public"),
 * 			},
 * 			ResourceGroupName: pulumi.String("DummyResourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"additionalProps1": pulumi.String("additional properties"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.confidentialledger.Ledger;
 * import com.pulumi.azurenative.confidentialledger.LedgerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ledger = new Ledger("ledger", LedgerArgs.builder()
 *             .ledgerName("DummyLedgerName")
 *             .location("EastUS")
 *             .properties(Map.ofEntries(
 *                 Map.entry("aadBasedSecurityPrincipals", Map.ofEntries(
 *                     Map.entry("ledgerRoleName", "Administrator"),
 *                     Map.entry("principalId", "34621747-6fc8-4771-a2eb-72f31c461f2e"),
 *                     Map.entry("tenantId", "bce123b9-2b7b-4975-8360-5ca0b9b1cd08")
 *                 )),
 *                 Map.entry("certBasedSecurityPrincipals", Map.ofEntries(
 *                     Map.entry("cert", "-----BEGIN CERTIFICATE-----MIIBsjCCATigAwIBAgIUZWIbyG79TniQLd2UxJuU74tqrKcwCgYIKoZIzj0EAwMwEDEOMAwGA1UEAwwFdXNlcjAwHhcNMjEwMzE2MTgwNjExWhcNMjIwMzE2MTgwNjExWjAQMQ4wDAYDVQQDDAV1c2VyMDB2MBAGByqGSM49AgEGBSuBBAAiA2IABBiWSo/j8EFit7aUMm5lF+lUmCu+IgfnpFD+7QMgLKtxRJ3aGSqgS/GpqcYVGddnODtSarNE/HyGKUFUolLPQ5ybHcouUk0kyfA7XMeSoUA4lBz63Wha8wmXo+NdBRo39qNTMFEwHQYDVR0OBBYEFPtuhrwgGjDFHeUUT4nGsXaZn69KMB8GA1UdIwQYMBaAFPtuhrwgGjDFHeUUT4nGsXaZn69KMA8GA1UdEwEB/wQFMAMBAf8wCgYIKoZIzj0EAwMDaAAwZQIxAOnozm2CyqRwSSQLls5r+mUHRGRyXHXwYtM4Dcst/VEZdmS9fqvHRCHbjUlO/+HNfgIwMWZ4FmsjD3wnPxONOm9YdVn/PRD7SsPRPbOjwBiE4EBGaHDsLjYAGDSGi7NJnSkA-----END CERTIFICATE-----"),
 *                     Map.entry("ledgerRoleName", "Reader")
 *                 )),
 *                 Map.entry("ledgerType", "Public")
 *             ))
 *             .resourceGroupName("DummyResourceGroupName")
 *             .tags(Map.of("additionalProps1", "additional properties"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:confidentialledger:Ledger DummyLedgerName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConfidentialLedger/ledgers/{ledgerName}
 * ```
 */
public class Ledger internal constructor(
    override val javaResource: com.pulumi.azurenative.confidentialledger.Ledger,
) : KotlinCustomResource(javaResource, LedgerMapper) {
    /**
     * The Azure location where the Confidential Ledger is running.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the Resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of Confidential Ledger Resource.
     */
    public val properties: Output<LedgerPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                ledgerPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Additional tags for Confidential Ledger
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LedgerMapper : ResourceMapper<Ledger> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.confidentialledger.Ledger::class == javaResource::class

    override fun map(javaResource: Resource): Ledger = Ledger(
        javaResource as
            com.pulumi.azurenative.confidentialledger.Ledger,
    )
}

/**
 * @see [Ledger].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Ledger].
 */
public suspend fun ledger(name: String, block: suspend LedgerResourceBuilder.() -> Unit): Ledger {
    val builder = LedgerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Ledger].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ledger(name: String): Ledger {
    val builder = LedgerResourceBuilder()
    builder.name(name)
    return builder.build()
}
