@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.inputs

import com.pulumi.azurenative.confluent.inputs.OfferDetailArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Confluent Offer detail
 * @property id Offer Id
 * @property planId Offer Plan Id
 * @property planName Offer Plan Name
 * @property publisherId Publisher Id
 * @property termUnit Offer Plan Term unit
 */
public data class OfferDetailArgs(
    public val id: Output<String>,
    public val planId: Output<String>,
    public val planName: Output<String>,
    public val publisherId: Output<String>,
    public val termUnit: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.confluent.inputs.OfferDetailArgs> {
    override fun toJava(): com.pulumi.azurenative.confluent.inputs.OfferDetailArgs =
        com.pulumi.azurenative.confluent.inputs.OfferDetailArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .planId(planId.applyValue({ args0 -> args0 }))
            .planName(planName.applyValue({ args0 -> args0 }))
            .publisherId(publisherId.applyValue({ args0 -> args0 }))
            .termUnit(termUnit.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OfferDetailArgs].
 */
@PulumiTagMarker
public class OfferDetailArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var planId: Output<String>? = null

    private var planName: Output<String>? = null

    private var publisherId: Output<String>? = null

    private var termUnit: Output<String>? = null

    /**
     * @param value Offer Id
     */
    @JvmName("wpauyptatfdnkime")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Offer Plan Id
     */
    @JvmName("mwuyitfnxljbmjpq")
    public suspend fun planId(`value`: Output<String>) {
        this.planId = value
    }

    /**
     * @param value Offer Plan Name
     */
    @JvmName("gkmbjmpxfemyejyc")
    public suspend fun planName(`value`: Output<String>) {
        this.planName = value
    }

    /**
     * @param value Publisher Id
     */
    @JvmName("uqbssksqusshhfwp")
    public suspend fun publisherId(`value`: Output<String>) {
        this.publisherId = value
    }

    /**
     * @param value Offer Plan Term unit
     */
    @JvmName("huvyebemmyqffgby")
    public suspend fun termUnit(`value`: Output<String>) {
        this.termUnit = value
    }

    /**
     * @param value Offer Id
     */
    @JvmName("ktpnsbcplcuyqjnr")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Offer Plan Id
     */
    @JvmName("jsdithxxescfawvd")
    public suspend fun planId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.planId = mapped
    }

    /**
     * @param value Offer Plan Name
     */
    @JvmName("vqbmwidyqjkmhqbl")
    public suspend fun planName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.planName = mapped
    }

    /**
     * @param value Publisher Id
     */
    @JvmName("ismdkgopcdtwjoej")
    public suspend fun publisherId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publisherId = mapped
    }

    /**
     * @param value Offer Plan Term unit
     */
    @JvmName("aftpbtutyefdcgeb")
    public suspend fun termUnit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.termUnit = mapped
    }

    internal fun build(): OfferDetailArgs = OfferDetailArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        planId = planId ?: throw PulumiNullFieldException("planId"),
        planName = planName ?: throw PulumiNullFieldException("planName"),
        publisherId = publisherId ?: throw PulumiNullFieldException("publisherId"),
        termUnit = termUnit ?: throw PulumiNullFieldException("termUnit"),
    )
}
