@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The network associated with this object
 * @property id ID of the referred resource
 * @property related API URL for accessing or modifying the referred object
 * @property resourceName CRN reference to the referred resource
 */
public data class ClusterByokEntityResponse(
    public val id: String? = null,
    public val related: String? = null,
    public val resourceName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.ClusterByokEntityResponse):
            ClusterByokEntityResponse = ClusterByokEntityResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            related = javaType.related().map({ args0 -> args0 }).orElse(null),
            resourceName = javaType.resourceName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
