@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Organization resource.
 * @property createdTime The creation time of the resource.
 * @property id The ARM id of the resource.
 * @property location Location of Organization resource
 * @property name The name of the resource.
 * @property offerDetail Confluent offer detail
 * @property organizationId Id of the Confluent organization.
 * @property provisioningState Provision states for confluent RP
 * @property ssoUrl SSO url for the Confluent organization.
 * @property systemData Metadata pertaining to creation and last modification of the resource
 * @property tags Organization resource tags
 * @property type The type of the resource.
 * @property userDetail Subscriber detail
 */
public data class GetOrganizationResult(
    public val createdTime: String,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val offerDetail: OfferDetailResponse,
    public val organizationId: String,
    public val provisioningState: String,
    public val ssoUrl: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val userDetail: UserDetailResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.GetOrganizationResult):
            GetOrganizationResult = GetOrganizationResult(
            createdTime = javaType.createdTime(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            offerDetail = javaType.offerDetail().let({ args0 ->
                com.pulumi.azurenative.confluent.kotlin.outputs.OfferDetailResponse.Companion.toKotlin(args0)
            }),
            organizationId = javaType.organizationId(),
            provisioningState = javaType.provisioningState(),
            ssoUrl = javaType.ssoUrl(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.confluent.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            userDetail = javaType.userDetail().let({ args0 ->
                com.pulumi.azurenative.confluent.kotlin.outputs.UserDetailResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
