@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * List cluster success response
 * @property data Data of the environments list
 * @property kind Type of response
 * @property metadata Metadata of the list
 */
public data class ListAccessClustersResult(
    public val `data`: List<ClusterRecordResponse>? = null,
    public val kind: String? = null,
    public val metadata: ConfluentListMetadataResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.ListAccessClustersResult):
            ListAccessClustersResult = ListAccessClustersResult(
            `data` = javaType.`data`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.ClusterRecordResponse.Companion.toKotlin(args0)
                })
            }),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.ConfluentListMetadataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
