@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Metadata of the data record
 * @property createdAt Created Date Time
 * @property deletedAt Deleted Date time
 * @property resourceName Resource name of the record
 * @property self Self lookup url
 * @property updatedAt Updated Date time
 */
public data class MetadataEntityResponse(
    public val createdAt: String? = null,
    public val deletedAt: String? = null,
    public val resourceName: String? = null,
    public val self: String? = null,
    public val updatedAt: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.MetadataEntityResponse):
            MetadataEntityResponse = MetadataEntityResponse(
            createdAt = javaType.createdAt().map({ args0 -> args0 }).orElse(null),
            deletedAt = javaType.deletedAt().map({ args0 -> args0 }).orElse(null),
            resourceName = javaType.resourceName().map({ args0 -> args0 }).orElse(null),
            self = javaType.self().map({ args0 -> args0 }).orElse(null),
            updatedAt = javaType.updatedAt().map({ args0 -> args0 }).orElse(null),
        )
    }
}
