@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Record of the environment
 * @property crnPattern A CRN that specifies the scope and resource patterns necessary for the role to bind
 * @property id Id of the role
 * @property kind The type of the resource.
 * @property metadata Metadata of the record
 * @property principal The principal User or Group to bind the role to
 * @property roleName The name of the role to bind to the principal
 */
public data class RoleBindingRecordResponse(
    public val crnPattern: String? = null,
    public val id: String? = null,
    public val kind: String? = null,
    public val metadata: MetadataEntityResponse? = null,
    public val principal: String? = null,
    public val roleName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.RoleBindingRecordResponse):
            RoleBindingRecordResponse = RoleBindingRecordResponse(
            crnPattern = javaType.crnPattern().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.MetadataEntityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            principal = javaType.principal().map({ args0 -> args0 }).orElse(null),
            roleName = javaType.roleName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
