@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin

import com.pulumi.azurenative.connectedvmwarevsphere.VMInstanceGuestAgentArgs.builder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.enums.ProvisioningAction
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GuestCredentialArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.GuestCredentialArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.HttpProxyConfigurationArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.HttpProxyConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the GuestAgent.
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2023-10-01.
 * ## Example Usage
 * ### CreateGuestAgent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vmInstanceGuestAgent = new AzureNative.ConnectedVMwarevSphere.VMInstanceGuestAgent("vmInstanceGuestAgent", new()
 *     {
 *         Credentials = new AzureNative.ConnectedVMwarevSphere.Inputs.GuestCredentialArgs
 *         {
 *             Password = "<password>",
 *             Username = "tempuser",
 *         },
 *         HttpProxyConfig = new AzureNative.ConnectedVMwarevSphere.Inputs.HttpProxyConfigurationArgs
 *         {
 *             HttpsProxy = "http://192.1.2.3:8080",
 *         },
 *         PrivateLinkScopeResourceId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.HybridCompute/privateLinkScopes/privateLinkScopeName",
 *         ProvisioningAction = "install",
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/connectedvmwarevsphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connectedvmwarevsphere.NewVMInstanceGuestAgent(ctx, "vmInstanceGuestAgent", &connectedvmwarevsphere.VMInstanceGuestAgentArgs{
 * 			Credentials: &connectedvmwarevsphere.GuestCredentialArgs{
 * 				Password: pulumi.String("<password>"),
 * 				Username: pulumi.String("tempuser"),
 * 			},
 * 			HttpProxyConfig: &connectedvmwarevsphere.HttpProxyConfigurationArgs{
 * 				HttpsProxy: pulumi.String("http://192.1.2.3:8080"),
 * 			},
 * 			PrivateLinkScopeResourceId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.HybridCompute/privateLinkScopes/privateLinkScopeName"),
 * 			ProvisioningAction:         pulumi.String("install"),
 * 			ResourceUri:                pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VMInstanceGuestAgent;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VMInstanceGuestAgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vmInstanceGuestAgent = new VMInstanceGuestAgent("vmInstanceGuestAgent", VMInstanceGuestAgentArgs.builder()
 *             .credentials(Map.ofEntries(
 *                 Map.entry("password", "<password>"),
 *                 Map.entry("username", "tempuser")
 *             ))
 *             .httpProxyConfig(Map.of("httpsProxy", "http://192.1.2.3:8080"))
 *             .privateLinkScopeResourceId("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.HybridCompute/privateLinkScopes/privateLinkScopeName")
 *             .provisioningAction("install")
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:connectedvmwarevsphere:VMInstanceGuestAgent default /{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/guestAgents/default
 * ```
 * @property credentials Username / Password Credentials to provision guest agent.
 * @property httpProxyConfig HTTP Proxy configuration for the VM.
 * @property privateLinkScopeResourceId The resource id of the private link scope this machine is assigned to, if any.
 * @property provisioningAction Gets or sets the guest agent provisioning action.
 * @property resourceUri The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
 */
public data class VMInstanceGuestAgentArgs(
    public val credentials: Output<GuestCredentialArgs>? = null,
    public val httpProxyConfig: Output<HttpProxyConfigurationArgs>? = null,
    public val privateLinkScopeResourceId: Output<String>? = null,
    public val provisioningAction: Output<Either<String, ProvisioningAction>>? = null,
    public val resourceUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.VMInstanceGuestAgentArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.VMInstanceGuestAgentArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.VMInstanceGuestAgentArgs.builder()
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpProxyConfig(httpProxyConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateLinkScopeResourceId(privateLinkScopeResourceId?.applyValue({ args0 -> args0 }))
            .provisioningAction(
                provisioningAction?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VMInstanceGuestAgentArgs].
 */
@PulumiTagMarker
public class VMInstanceGuestAgentArgsBuilder internal constructor() {
    private var credentials: Output<GuestCredentialArgs>? = null

    private var httpProxyConfig: Output<HttpProxyConfigurationArgs>? = null

    private var privateLinkScopeResourceId: Output<String>? = null

    private var provisioningAction: Output<Either<String, ProvisioningAction>>? = null

    private var resourceUri: Output<String>? = null

    /**
     * @param value Username / Password Credentials to provision guest agent.
     */
    @JvmName("ssndequggdltbcbl")
    public suspend fun credentials(`value`: Output<GuestCredentialArgs>) {
        this.credentials = value
    }

    /**
     * @param value HTTP Proxy configuration for the VM.
     */
    @JvmName("thsmvbgtqdjouhqn")
    public suspend fun httpProxyConfig(`value`: Output<HttpProxyConfigurationArgs>) {
        this.httpProxyConfig = value
    }

    /**
     * @param value The resource id of the private link scope this machine is assigned to, if any.
     */
    @JvmName("rvlkhuxtwmyxdahs")
    public suspend fun privateLinkScopeResourceId(`value`: Output<String>) {
        this.privateLinkScopeResourceId = value
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("qwyiqqgwajuygnma")
    public suspend fun provisioningAction(`value`: Output<Either<String, ProvisioningAction>>) {
        this.provisioningAction = value
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     */
    @JvmName("flylmmyamdrkdupo")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value Username / Password Credentials to provision guest agent.
     */
    @JvmName("bdiwmwgiviqlqvyi")
    public suspend fun credentials(`value`: GuestCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument Username / Password Credentials to provision guest agent.
     */
    @JvmName("vomppetdtttlmleu")
    public suspend fun credentials(argument: suspend GuestCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = GuestCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value HTTP Proxy configuration for the VM.
     */
    @JvmName("rxnpoyylccjgwxjv")
    public suspend fun httpProxyConfig(`value`: HttpProxyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpProxyConfig = mapped
    }

    /**
     * @param argument HTTP Proxy configuration for the VM.
     */
    @JvmName("ngkahcpeoraooxvs")
    public suspend
    fun httpProxyConfig(argument: suspend HttpProxyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = HttpProxyConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpProxyConfig = mapped
    }

    /**
     * @param value The resource id of the private link scope this machine is assigned to, if any.
     */
    @JvmName("kuatfhhcgxtjinyu")
    public suspend fun privateLinkScopeResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkScopeResourceId = mapped
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("vwpvulgxmmvxfypw")
    public suspend fun provisioningAction(`value`: Either<String, ProvisioningAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningAction = mapped
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("qvqkauyfdmeqxdlg")
    public fun provisioningAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningAction = mapped
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("totuvqiuuaxeoxdx")
    public fun provisioningAction(`value`: ProvisioningAction) {
        val toBeMapped = Either.ofRight<String, ProvisioningAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningAction = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     */
    @JvmName("instfbnipftkqdvf")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    internal fun build(): VMInstanceGuestAgentArgs = VMInstanceGuestAgentArgs(
        credentials = credentials,
        httpProxyConfig = httpProxyConfig,
        privateLinkScopeResourceId = privateLinkScopeResourceId,
        provisioningAction = provisioningAction,
        resourceUri = resourceUri,
    )
}
