@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetVCenterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The Resource Group Name.
 * @property vcenterName Name of the vCenter.
 */
public data class GetVCenterPlainArgs(
    public val resourceGroupName: String,
    public val vcenterName: String,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetVCenterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetVCenterPlainArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetVCenterPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vcenterName(vcenterName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVCenterPlainArgs].
 */
@PulumiTagMarker
public class GetVCenterPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var vcenterName: String? = null

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("uqbnmucrippplmam")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the vCenter.
     */
    @JvmName("iqslqaxsycjpwpbb")
    public suspend fun vcenterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vcenterName = mapped
    }

    internal fun build(): GetVCenterPlainArgs = GetVCenterPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vcenterName = vcenterName ?: throw PulumiNullFieldException("vcenterName"),
    )
}
