@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetVirtualMachineTemplatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The Resource Group Name.
 * @property virtualMachineTemplateName Name of the virtual machine template resource.
 */
public data class GetVirtualMachineTemplatePlainArgs(
    public val resourceGroupName: String,
    public val virtualMachineTemplateName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetVirtualMachineTemplatePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetVirtualMachineTemplatePlainArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.GetVirtualMachineTemplatePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualMachineTemplateName(virtualMachineTemplateName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualMachineTemplatePlainArgs].
 */
@PulumiTagMarker
public class GetVirtualMachineTemplatePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var virtualMachineTemplateName: String? = null

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("deatewgmmvgiwcsn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the virtual machine template resource.
     */
    @JvmName("pxaahffctqnhemna")
    public suspend fun virtualMachineTemplateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualMachineTemplateName = mapped
    }

    internal fun build(): GetVirtualMachineTemplatePlainArgs = GetVirtualMachineTemplatePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualMachineTemplateName = virtualMachineTemplateName ?: throw
            PulumiNullFieldException("virtualMachineTemplateName"),
    )
}
