@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.HardwareProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the hardware settings for the virtual machine.
 * @property memorySizeMB Gets or sets memory size in MBs for the vm.
 * @property numCPUs Gets or sets the number of vCPUs for the vm.
 * @property numCoresPerSocket Gets or sets the number of cores per socket for the vm. Defaults to 1 if unspecified.
 */
public data class HardwareProfileArgs(
    public val memorySizeMB: Output<Int>? = null,
    public val numCPUs: Output<Int>? = null,
    public val numCoresPerSocket: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.HardwareProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.HardwareProfileArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.HardwareProfileArgs.builder()
            .memorySizeMB(memorySizeMB?.applyValue({ args0 -> args0 }))
            .numCPUs(numCPUs?.applyValue({ args0 -> args0 }))
            .numCoresPerSocket(numCoresPerSocket?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HardwareProfileArgs].
 */
@PulumiTagMarker
public class HardwareProfileArgsBuilder internal constructor() {
    private var memorySizeMB: Output<Int>? = null

    private var numCPUs: Output<Int>? = null

    private var numCoresPerSocket: Output<Int>? = null

    /**
     * @param value Gets or sets memory size in MBs for the vm.
     */
    @JvmName("ftbincruktorfokf")
    public suspend fun memorySizeMB(`value`: Output<Int>) {
        this.memorySizeMB = value
    }

    /**
     * @param value Gets or sets the number of vCPUs for the vm.
     */
    @JvmName("xqkjjlswguqguxcp")
    public suspend fun numCPUs(`value`: Output<Int>) {
        this.numCPUs = value
    }

    /**
     * @param value Gets or sets the number of cores per socket for the vm. Defaults to 1 if unspecified.
     */
    @JvmName("mmugdaskqejpgjxa")
    public suspend fun numCoresPerSocket(`value`: Output<Int>) {
        this.numCoresPerSocket = value
    }

    /**
     * @param value Gets or sets memory size in MBs for the vm.
     */
    @JvmName("nsistlpxxmyhorsc")
    public suspend fun memorySizeMB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memorySizeMB = mapped
    }

    /**
     * @param value Gets or sets the number of vCPUs for the vm.
     */
    @JvmName("nkciopuwjbxltjiq")
    public suspend fun numCPUs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numCPUs = mapped
    }

    /**
     * @param value Gets or sets the number of cores per socket for the vm. Defaults to 1 if unspecified.
     */
    @JvmName("chwcoiyrcjyptxxs")
    public suspend fun numCoresPerSocket(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numCoresPerSocket = mapped
    }

    internal fun build(): HardwareProfileArgs = HardwareProfileArgs(
        memorySizeMB = memorySizeMB,
        numCPUs = numCPUs,
        numCoresPerSocket = numCoresPerSocket,
    )
}
