@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.SecurityProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies the Security profile settings for the virtual machine.
 * @property uefiSettings Specifies the security settings like secure boot used while creating the virtual machine.
 */
public data class SecurityProfileArgs(
    public val uefiSettings: Output<UefiSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.SecurityProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.SecurityProfileArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.SecurityProfileArgs.builder()
            .uefiSettings(uefiSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SecurityProfileArgs].
 */
@PulumiTagMarker
public class SecurityProfileArgsBuilder internal constructor() {
    private var uefiSettings: Output<UefiSettingsArgs>? = null

    /**
     * @param value Specifies the security settings like secure boot used while creating the virtual machine.
     */
    @JvmName("joiwpcbbnroiqlqn")
    public suspend fun uefiSettings(`value`: Output<UefiSettingsArgs>) {
        this.uefiSettings = value
    }

    /**
     * @param value Specifies the security settings like secure boot used while creating the virtual machine.
     */
    @JvmName("yayjoapxwyarpjhk")
    public suspend fun uefiSettings(`value`: UefiSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uefiSettings = mapped
    }

    /**
     * @param argument Specifies the security settings like secure boot used while creating the virtual machine.
     */
    @JvmName("prmawjjwaueptsan")
    public suspend fun uefiSettings(argument: suspend UefiSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UefiSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.uefiSettings = mapped
    }

    internal fun build(): SecurityProfileArgs = SecurityProfileArgs(
        uefiSettings = uefiSettings,
    )
}
