@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.UefiSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the security settings like secure boot used while creating the virtual machine.
 * @property secureBootEnabled Specifies whether secure boot should be enabled on the virtual machine.
 */
public data class UefiSettingsArgs(
    public val secureBootEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.UefiSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.UefiSettingsArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.UefiSettingsArgs.builder()
            .secureBootEnabled(secureBootEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UefiSettingsArgs].
 */
@PulumiTagMarker
public class UefiSettingsArgsBuilder internal constructor() {
    private var secureBootEnabled: Output<Boolean>? = null

    /**
     * @param value Specifies whether secure boot should be enabled on the virtual machine.
     */
    @JvmName("kuhvancyfuqroyow")
    public suspend fun secureBootEnabled(`value`: Output<Boolean>) {
        this.secureBootEnabled = value
    }

    /**
     * @param value Specifies whether secure boot should be enabled on the virtual machine.
     */
    @JvmName("wtpomsadfbdmkllu")
    public suspend fun secureBootEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secureBootEnabled = mapped
    }

    internal fun build(): UefiSettingsArgs = UefiSettingsArgs(
        secureBootEnabled = secureBootEnabled,
    )
}
