@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the network interface ip settings.
 * @property allocationMethod Gets or sets the nic allocation method.
 * @property dnsServers Gets or sets the dns servers.
 * @property gateway Gets or sets the gateway.
 * @property ipAddress Gets or sets the ip address for the nic.
 * @property ipAddressInfo Gets or sets the IP address information being reported for this NIC. This contains the same IPv4 information above plus IPV6 information.
 * @property primaryWinsServer Gets or sets the primary server.
 * @property secondaryWinsServer Gets or sets the secondary server.
 * @property subnetMask Gets or sets the mask.
 */
public data class NicIPSettingsResponse(
    public val allocationMethod: String? = null,
    public val dnsServers: List<String>? = null,
    public val gateway: List<String>? = null,
    public val ipAddress: String? = null,
    public val ipAddressInfo: List<NicIPAddressSettingsResponse>,
    public val primaryWinsServer: String,
    public val secondaryWinsServer: String,
    public val subnetMask: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.NicIPSettingsResponse):
            NicIPSettingsResponse = NicIPSettingsResponse(
            allocationMethod = javaType.allocationMethod().map({ args0 -> args0 }).orElse(null),
            dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
            gateway = javaType.gateway().map({ args0 -> args0 }),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            ipAddressInfo = javaType.ipAddressInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.NicIPAddressSettingsResponse.Companion.toKotlin(args0)
                })
            }),
            primaryWinsServer = javaType.primaryWinsServer(),
            secondaryWinsServer = javaType.secondaryWinsServer(),
            subnetMask = javaType.subnetMask().map({ args0 -> args0 }).orElse(null),
        )
    }
}
