@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the operating system settings for the virtual machine.
 * @property adminUsername Gets or sets administrator username.
 * @property computerName Gets or sets computer name.
 * @property guestId Gets or sets the guestId.
 * @property osSku Gets or sets os sku.
 * @property osType Gets or sets the type of the os.
 * @property toolsRunningStatus Gets or sets the current running status of VMware Tools running in the guest operating system.
 * @property toolsVersion Gets or sets the current version of VMware Tools.
 * @property toolsVersionStatus Gets or sets the current version status of VMware Tools installed in the guest operating system.
 */
public data class OsProfileForVMInstanceResponse(
    public val adminUsername: String? = null,
    public val computerName: String? = null,
    public val guestId: String? = null,
    public val osSku: String,
    public val osType: String? = null,
    public val toolsRunningStatus: String,
    public val toolsVersion: String,
    public val toolsVersionStatus: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.OsProfileForVMInstanceResponse):
            OsProfileForVMInstanceResponse = OsProfileForVMInstanceResponse(
            adminUsername = javaType.adminUsername().map({ args0 -> args0 }).orElse(null),
            computerName = javaType.computerName().map({ args0 -> args0 }).orElse(null),
            guestId = javaType.guestId().map({ args0 -> args0 }).orElse(null),
            osSku = javaType.osSku(),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            toolsRunningStatus = javaType.toolsRunningStatus(),
            toolsVersion = javaType.toolsVersion(),
            toolsVersionStatus = javaType.toolsVersionStatus(),
        )
    }
}
