@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Virtual disk model
 * @property controllerKey Gets or sets the controller id.
 * @property deviceKey Gets or sets the device key value.
 * @property deviceName Gets or sets the device name.
 * @property diskMode Gets or sets the disk mode.
 * @property diskObjectId Gets or sets the disk object id.
 * @property diskSizeGB Gets or sets the disk total size.
 * @property diskType Gets or sets the disk backing type.
 * @property label Gets or sets the label of the virtual disk in vCenter.
 * @property name Gets or sets the name of the virtual disk.
 * @property unitNumber Gets or sets the unit number of the disk on the controller.
 */
public data class VirtualDiskResponse(
    public val controllerKey: Int? = null,
    public val deviceKey: Int? = null,
    public val deviceName: String? = null,
    public val diskMode: String? = null,
    public val diskObjectId: String,
    public val diskSizeGB: Int? = null,
    public val diskType: String? = null,
    public val label: String,
    public val name: String? = null,
    public val unitNumber: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.VirtualDiskResponse):
            VirtualDiskResponse = VirtualDiskResponse(
            controllerKey = javaType.controllerKey().map({ args0 -> args0 }).orElse(null),
            deviceKey = javaType.deviceKey().map({ args0 -> args0 }).orElse(null),
            deviceName = javaType.deviceName().map({ args0 -> args0 }).orElse(null),
            diskMode = javaType.diskMode().map({ args0 -> args0 }).orElse(null),
            diskObjectId = javaType.diskObjectId(),
            diskSizeGB = javaType.diskSizeGB().map({ args0 -> args0 }).orElse(null),
            diskType = javaType.diskType().map({ args0 -> args0 }).orElse(null),
            label = javaType.label(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            unitNumber = javaType.unitNumber().map({ args0 -> args0 }).orElse(null),
        )
    }
}
