@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin

import com.pulumi.azurenative.consumption.BudgetArgs.builder
import com.pulumi.azurenative.consumption.kotlin.enums.CategoryType
import com.pulumi.azurenative.consumption.kotlin.enums.TimeGrainType
import com.pulumi.azurenative.consumption.kotlin.inputs.BudgetFilterArgs
import com.pulumi.azurenative.consumption.kotlin.inputs.BudgetFilterArgsBuilder
import com.pulumi.azurenative.consumption.kotlin.inputs.BudgetTimePeriodArgs
import com.pulumi.azurenative.consumption.kotlin.inputs.BudgetTimePeriodArgsBuilder
import com.pulumi.azurenative.consumption.kotlin.inputs.NotificationArgs
import com.pulumi.azurenative.consumption.kotlin.inputs.NotificationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A budget resource.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * Other available API versions: 2017-12-30-preview, 2018-10-01, 2019-05-01, 2019-06-01, 2023-11-01.
 * ## Example Usage
 * ### CreateOrUpdateBudget
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var budget = new AzureNative.Consumption.Budget("budget", new()
 *     {
 *         Amount = 100.65,
 *         BudgetName = "TestBudget",
 *         Category = "Cost",
 *         ETag = "\"1d34d016a593709\"",
 *         Filter = new AzureNative.Consumption.Inputs.BudgetFilterArgs
 *         {
 *             And = new[]
 *             {
 *                 new AzureNative.Consumption.Inputs.BudgetFilterPropertiesArgs
 *                 {
 *                     Dimensions = new AzureNative.Consumption.Inputs.BudgetComparisonExpressionArgs
 *                     {
 *                         Name = "ResourceId",
 *                         Operator = "In",
 *                         Values = new[]
 *                         {
 *                             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Compute/virtualMachines/MSVM2",
 *                             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Compute/virtualMachines/platformcloudplatformGeneric1",
 *                         },
 *                     },
 *                 },
 *                 new AzureNative.Consumption.Inputs.BudgetFilterPropertiesArgs
 *                 {
 *                     Tags = new AzureNative.Consumption.Inputs.BudgetComparisonExpressionArgs
 *                     {
 *                         Name = "category",
 *                         Operator = "In",
 *                         Values = new[]
 *                         {
 *                             "Dev",
 *                             "Prod",
 *                         },
 *                     },
 *                 },
 *                 new AzureNative.Consumption.Inputs.BudgetFilterPropertiesArgs
 *                 {
 *                     Tags = new AzureNative.Consumption.Inputs.BudgetComparisonExpressionArgs
 *                     {
 *                         Name = "department",
 *                         Operator = "In",
 *                         Values = new[]
 *                         {
 *                             "engineering",
 *                             "sales",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         Notifications =
 *         {
 *             { "Actual_GreaterThan_80_Percent", new AzureNative.Consumption.Inputs.NotificationArgs
 *             {
 *                 ContactEmails = new[]
 *                 {
 *                     "johndoe@contoso.com",
 *                     "janesmith@contoso.com",
 *                 },
 *                 ContactGroups = new[]
 *                 {
 *                     "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/microsoft.insights/actionGroups/SampleActionGroup",
 *                 },
 *                 ContactRoles = new[]
 *                 {
 *                     "Contributor",
 *                     "Reader",
 *                 },
 *                 Enabled = true,
 *                 Locale = "en-us",
 *                 Operator = "GreaterThan",
 *                 Threshold = 80,
 *                 ThresholdType = "Actual",
 *             } },
 *         },
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         TimeGrain = "Monthly",
 *         TimePeriod = new AzureNative.Consumption.Inputs.BudgetTimePeriodArgs
 *         {
 *             EndDate = "2018-10-31T00:00:00Z",
 *             StartDate = "2017-10-01T00:00:00Z",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/consumption/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := consumption.NewBudget(ctx, "budget", &consumption.BudgetArgs{
 * Amount: pulumi.Float64(100.65),
 * BudgetName: pulumi.String("TestBudget"),
 * Category: pulumi.String("Cost"),
 * ETag: pulumi.String("\"1d34d016a593709\""),
 * Filter: consumption.BudgetFilterResponse{
 * And: consumption.BudgetFilterPropertiesArray{
 * interface{}{
 * Dimensions: &consumption.BudgetComparisonExpressionArgs{
 * Name: pulumi.String("ResourceId"),
 * Operator: pulumi.String("In"),
 * Values: pulumi.StringArray{
 * pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Compute/virtualMachines/MSVM2"),
 * pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Compute/virtualMachines/platformcloudplatformGeneric1"),
 * },
 * },
 * },
 * interface{}{
 * Tags: &consumption.BudgetComparisonExpressionArgs{
 * Name: pulumi.String("category"),
 * Operator: pulumi.String("In"),
 * Values: pulumi.StringArray{
 * pulumi.String("Dev"),
 * pulumi.String("Prod"),
 * },
 * },
 * },
 * interface{}{
 * Tags: &consumption.BudgetComparisonExpressionArgs{
 * Name: pulumi.String("department"),
 * Operator: pulumi.String("In"),
 * Values: pulumi.StringArray{
 * pulumi.String("engineering"),
 * pulumi.String("sales"),
 * },
 * },
 * },
 * },
 * },
 * Notifications: consumption.NotificationMap{
 * "Actual_GreaterThan_80_Percent": &consumption.NotificationArgs{
 * ContactEmails: pulumi.StringArray{
 * pulumi.String("johndoe@contoso.com"),
 * pulumi.String("janesmith@contoso.com"),
 * },
 * ContactGroups: pulumi.StringArray{
 * pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/microsoft.insights/actionGroups/SampleActionGroup"),
 * },
 * ContactRoles: pulumi.StringArray{
 * pulumi.String("Contributor"),
 * pulumi.String("Reader"),
 * },
 * Enabled: pulumi.Bool(true),
 * Locale: pulumi.String("en-us"),
 * Operator: pulumi.String("GreaterThan"),
 * Threshold: pulumi.Float64(80),
 * ThresholdType: pulumi.String("Actual"),
 * },
 * },
 * Scope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * TimeGrain: pulumi.String("Monthly"),
 * TimePeriod: &consumption.BudgetTimePeriodArgs{
 * EndDate: pulumi.String("2018-10-31T00:00:00Z"),
 * StartDate: pulumi.String("2017-10-01T00:00:00Z"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.consumption.Budget;
 * import com.pulumi.azurenative.consumption.BudgetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var budget = new Budget("budget", BudgetArgs.builder()
 *             .amount(100.65)
 *             .budgetName("TestBudget")
 *             .category("Cost")
 *             .eTag("\"1d34d016a593709\"")
 *             .filter(Map.of("and",
 *                 Map.of("dimensions", Map.ofEntries(
 *                     Map.entry("name", "ResourceId"),
 *                     Map.entry("operator", "In"),
 *                     Map.entry("values",
 *                         "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Compute/virtualMachines/MSVM2",
 *                         "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Compute/virtualMachines/platformcloudplatformGeneric1")
 *                 )),
 *                 Map.of("tags", Map.ofEntries(
 *                     Map.entry("name", "category"),
 *                     Map.entry("operator", "In"),
 *                     Map.entry("values",
 *                         "Dev",
 *                         "Prod")
 *                 )),
 *                 Map.of("tags", Map.ofEntries(
 *                     Map.entry("name", "department"),
 *                     Map.entry("operator", "In"),
 *                     Map.entry("values",
 *                         "engineering",
 *                         "sales")
 *                 ))))
 *             .notifications(Map.of("Actual_GreaterThan_80_Percent", Map.ofEntries(
 *                 Map.entry("contactEmails",
 *                     "johndoe@contoso.com",
 *                     "janesmith@contoso.com"),
 *                 Map.entry("contactGroups", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/microsoft.insights/actionGroups/SampleActionGroup"),
 *                 Map.entry("contactRoles",
 *                     "Contributor",
 *                     "Reader"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("locale", "en-us"),
 *                 Map.entry("operator", "GreaterThan"),
 *                 Map.entry("threshold", 80),
 *                 Map.entry("thresholdType", "Actual")
 *             )))
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .timeGrain("Monthly")
 *             .timePeriod(Map.ofEntries(
 *                 Map.entry("endDate", "2018-10-31T00:00:00Z"),
 *                 Map.entry("startDate", "2017-10-01T00:00:00Z")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:consumption:Budget TestBudget /{scope}/providers/Microsoft.Consumption/budgets/{budgetName}
 * ```
 * @property amount The total amount of cost to track with the budget
 * @property budgetName Budget Name.
 * @property category The category of the budget, whether the budget tracks cost or usage.
 * @property eTag eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
 * @property filter May be used to filter budgets by user-specified dimensions and/or tags.
 * @property notifications Dictionary of notifications associated with the budget. Budget can have up to five notifications.
 * @property scope The scope associated with budget operations. This includes '/subscriptions/{subscriptionId}/' for subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope.
 * @property timeGrain The time covered by a budget. Tracking of the amount will be reset based on the time grain. BillingMonth, BillingQuarter, and BillingAnnual are only supported by WD customers
 * @property timePeriod Has start and end date of the budget. The start date must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should  be selected within the timegrain period. There are no restrictions on the end date.
 */
public data class BudgetArgs(
    public val amount: Output<Double>? = null,
    public val budgetName: Output<String>? = null,
    public val category: Output<Either<String, CategoryType>>? = null,
    public val eTag: Output<String>? = null,
    public val filter: Output<BudgetFilterArgs>? = null,
    public val notifications: Output<Map<String, NotificationArgs>>? = null,
    public val scope: Output<String>? = null,
    public val timeGrain: Output<Either<String, TimeGrainType>>? = null,
    public val timePeriod: Output<BudgetTimePeriodArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.consumption.BudgetArgs> {
    override fun toJava(): com.pulumi.azurenative.consumption.BudgetArgs =
        com.pulumi.azurenative.consumption.BudgetArgs.builder()
            .amount(amount?.applyValue({ args0 -> args0 }))
            .budgetName(budgetName?.applyValue({ args0 -> args0 }))
            .category(
                category?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .notifications(
                notifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .scope(scope?.applyValue({ args0 -> args0 }))
            .timeGrain(
                timeGrain?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .timePeriod(timePeriod?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BudgetArgs].
 */
@PulumiTagMarker
public class BudgetArgsBuilder internal constructor() {
    private var amount: Output<Double>? = null

    private var budgetName: Output<String>? = null

    private var category: Output<Either<String, CategoryType>>? = null

    private var eTag: Output<String>? = null

    private var filter: Output<BudgetFilterArgs>? = null

    private var notifications: Output<Map<String, NotificationArgs>>? = null

    private var scope: Output<String>? = null

    private var timeGrain: Output<Either<String, TimeGrainType>>? = null

    private var timePeriod: Output<BudgetTimePeriodArgs>? = null

    /**
     * @param value The total amount of cost to track with the budget
     */
    @JvmName("ruaooelrnbfycufa")
    public suspend fun amount(`value`: Output<Double>) {
        this.amount = value
    }

    /**
     * @param value Budget Name.
     */
    @JvmName("skxmdsyqqbwhnrga")
    public suspend fun budgetName(`value`: Output<String>) {
        this.budgetName = value
    }

    /**
     * @param value The category of the budget, whether the budget tracks cost or usage.
     */
    @JvmName("nxhfhejccescyubl")
    public suspend fun category(`value`: Output<Either<String, CategoryType>>) {
        this.category = value
    }

    /**
     * @param value eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    @JvmName("tcueiuqbafprxboc")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value May be used to filter budgets by user-specified dimensions and/or tags.
     */
    @JvmName("obrwopbeqtyhajoy")
    public suspend fun filter(`value`: Output<BudgetFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value Dictionary of notifications associated with the budget. Budget can have up to five notifications.
     */
    @JvmName("pvmvkapvadfutocv")
    public suspend fun notifications(`value`: Output<Map<String, NotificationArgs>>) {
        this.notifications = value
    }

    /**
     * @param value The scope associated with budget operations. This includes '/subscriptions/{subscriptionId}/' for subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope.
     */
    @JvmName("cbliorpiwiydyoba")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The time covered by a budget. Tracking of the amount will be reset based on the time grain. BillingMonth, BillingQuarter, and BillingAnnual are only supported by WD customers
     */
    @JvmName("pabbngmgbfvdbxgf")
    public suspend fun timeGrain(`value`: Output<Either<String, TimeGrainType>>) {
        this.timeGrain = value
    }

    /**
     * @param value Has start and end date of the budget. The start date must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should  be selected within the timegrain period. There are no restrictions on the end date.
     */
    @JvmName("knbownwbjjqrguep")
    public suspend fun timePeriod(`value`: Output<BudgetTimePeriodArgs>) {
        this.timePeriod = value
    }

    /**
     * @param value The total amount of cost to track with the budget
     */
    @JvmName("schhpgyfnkldtyhb")
    public suspend fun amount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amount = mapped
    }

    /**
     * @param value Budget Name.
     */
    @JvmName("oqbnyrgcaufqhkmv")
    public suspend fun budgetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.budgetName = mapped
    }

    /**
     * @param value The category of the budget, whether the budget tracks cost or usage.
     */
    @JvmName("tndrkykgofgaehqn")
    public suspend fun category(`value`: Either<String, CategoryType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The category of the budget, whether the budget tracks cost or usage.
     */
    @JvmName("amwktdnvvwrgtfwc")
    public fun category(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CategoryType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The category of the budget, whether the budget tracks cost or usage.
     */
    @JvmName("ovgoebfmhvanlqaj")
    public fun category(`value`: CategoryType) {
        val toBeMapped = Either.ofRight<String, CategoryType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    @JvmName("ncldrawrgwekuryy")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value May be used to filter budgets by user-specified dimensions and/or tags.
     */
    @JvmName("rvkjrbfuqtlxfdkh")
    public suspend fun filter(`value`: BudgetFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument May be used to filter budgets by user-specified dimensions and/or tags.
     */
    @JvmName("wjttuhxkvunfbsbq")
    public suspend fun filter(argument: suspend BudgetFilterArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value Dictionary of notifications associated with the budget. Budget can have up to five notifications.
     */
    @JvmName("bgdxemitfkqgqdyx")
    public suspend fun notifications(`value`: Map<String, NotificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifications = mapped
    }

    /**
     * @param argument Dictionary of notifications associated with the budget. Budget can have up to five notifications.
     */
    @JvmName("vuhsbjdscmfluxvj")
    public suspend fun notifications(
        vararg
        argument: Pair<String, suspend NotificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                NotificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.notifications = mapped
    }

    /**
     * @param values Dictionary of notifications associated with the budget. Budget can have up to five notifications.
     */
    @JvmName("nsdomecfmtdnujqc")
    public fun notifications(vararg values: Pair<String, NotificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifications = mapped
    }

    /**
     * @param value The scope associated with budget operations. This includes '/subscriptions/{subscriptionId}/' for subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope.
     */
    @JvmName("uchnyabyopmjyage")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The time covered by a budget. Tracking of the amount will be reset based on the time grain. BillingMonth, BillingQuarter, and BillingAnnual are only supported by WD customers
     */
    @JvmName("cdkgvyvukjanhxdn")
    public suspend fun timeGrain(`value`: Either<String, TimeGrainType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeGrain = mapped
    }

    /**
     * @param value The time covered by a budget. Tracking of the amount will be reset based on the time grain. BillingMonth, BillingQuarter, and BillingAnnual are only supported by WD customers
     */
    @JvmName("spiclxgyifaereoj")
    public fun timeGrain(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TimeGrainType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeGrain = mapped
    }

    /**
     * @param value The time covered by a budget. Tracking of the amount will be reset based on the time grain. BillingMonth, BillingQuarter, and BillingAnnual are only supported by WD customers
     */
    @JvmName("nykbdotnaojjypyq")
    public fun timeGrain(`value`: TimeGrainType) {
        val toBeMapped = Either.ofRight<String, TimeGrainType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeGrain = mapped
    }

    /**
     * @param value Has start and end date of the budget. The start date must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should  be selected within the timegrain period. There are no restrictions on the end date.
     */
    @JvmName("xhvkcihmbbtyvcol")
    public suspend fun timePeriod(`value`: BudgetTimePeriodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timePeriod = mapped
    }

    /**
     * @param argument Has start and end date of the budget. The start date must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should  be selected within the timegrain period. There are no restrictions on the end date.
     */
    @JvmName("wqsxafaevphosjje")
    public suspend fun timePeriod(argument: suspend BudgetTimePeriodArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetTimePeriodArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timePeriod = mapped
    }

    internal fun build(): BudgetArgs = BudgetArgs(
        amount = amount,
        budgetName = budgetName,
        category = category,
        eTag = eTag,
        filter = filter,
        notifications = notifications,
        scope = scope,
        timeGrain = timeGrain,
        timePeriod = timePeriod,
    )
}
