@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin.inputs

import com.pulumi.azurenative.consumption.inputs.BudgetFilterPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Dimensions or Tags to filter a budget by.
 * @property dimensions Has comparison expression for a dimension
 * @property tags Has comparison expression for a tag
 */
public data class BudgetFilterPropertiesArgs(
    public val dimensions: Output<BudgetComparisonExpressionArgs>? = null,
    public val tags: Output<BudgetComparisonExpressionArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.consumption.inputs.BudgetFilterPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.consumption.inputs.BudgetFilterPropertiesArgs =
        com.pulumi.azurenative.consumption.inputs.BudgetFilterPropertiesArgs.builder()
            .dimensions(dimensions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BudgetFilterPropertiesArgs].
 */
@PulumiTagMarker
public class BudgetFilterPropertiesArgsBuilder internal constructor() {
    private var dimensions: Output<BudgetComparisonExpressionArgs>? = null

    private var tags: Output<BudgetComparisonExpressionArgs>? = null

    /**
     * @param value Has comparison expression for a dimension
     */
    @JvmName("bwqhdwysiewelfty")
    public suspend fun dimensions(`value`: Output<BudgetComparisonExpressionArgs>) {
        this.dimensions = value
    }

    /**
     * @param value Has comparison expression for a tag
     */
    @JvmName("lmpfwbvrpcbiqgpg")
    public suspend fun tags(`value`: Output<BudgetComparisonExpressionArgs>) {
        this.tags = value
    }

    /**
     * @param value Has comparison expression for a dimension
     */
    @JvmName("cuoeploolkbqtbxq")
    public suspend fun dimensions(`value`: BudgetComparisonExpressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument Has comparison expression for a dimension
     */
    @JvmName("qkytmteeuqoqmcbw")
    public suspend
    fun dimensions(argument: suspend BudgetComparisonExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetComparisonExpressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param value Has comparison expression for a tag
     */
    @JvmName("vqbxxgtolvkfdjrk")
    public suspend fun tags(`value`: BudgetComparisonExpressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Has comparison expression for a tag
     */
    @JvmName("laolkpfcifcnimnd")
    public suspend fun tags(argument: suspend BudgetComparisonExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetComparisonExpressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): BudgetFilterPropertiesArgs = BudgetFilterPropertiesArgs(
        dimensions = dimensions,
        tags = tags,
    )
}
