@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The value representing the security enum. The 'Unsecure' value is the default value if not selected and means the object's domain name label is not secured against subdomain takeover. The 'TenantReuse' value is the default value if selected and means the object's domain name label can be reused within the same tenant. The 'SubscriptionReuse' value means the object's domain name label can be reused within the same subscription. The 'ResourceGroupReuse' value means the object's domain name label can be reused within the same resource group. The 'NoReuse' value means the object's domain name label cannot be reused within the same resource group, subscription, or tenant.
 */
public enum class DnsNameLabelReusePolicy(
    public val javaValue: com.pulumi.azurenative.containerinstance.enums.DnsNameLabelReusePolicy,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.enums.DnsNameLabelReusePolicy> {
    Unsecure(com.pulumi.azurenative.containerinstance.enums.DnsNameLabelReusePolicy.Unsecure),
    TenantReuse(com.pulumi.azurenative.containerinstance.enums.DnsNameLabelReusePolicy.TenantReuse),
    SubscriptionReuse(com.pulumi.azurenative.containerinstance.enums.DnsNameLabelReusePolicy.SubscriptionReuse),
    ResourceGroupReuse(com.pulumi.azurenative.containerinstance.enums.DnsNameLabelReusePolicy.ResourceGroupReuse),
    Noreuse(com.pulumi.azurenative.containerinstance.enums.DnsNameLabelReusePolicy.Noreuse),
    ;

    override fun toJava(): com.pulumi.azurenative.containerinstance.enums.DnsNameLabelReusePolicy =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.enums.DnsNameLabelReusePolicy):
            DnsNameLabelReusePolicy =
            DnsNameLabelReusePolicy.values().first { it.javaValue == javaType }
    }
}
