@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.AzureFileVolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of the Azure File volume. Azure File shares are mounted as volumes.
 * @property readOnly The flag indicating whether the Azure File shared mounted as a volume is read-only.
 * @property shareName The name of the Azure File share to be mounted as a volume.
 * @property storageAccountKey The storage account access key used to access the Azure File share.
 * @property storageAccountName The name of the storage account that contains the Azure File share.
 */
public data class AzureFileVolumeArgs(
    public val readOnly: Output<Boolean>? = null,
    public val shareName: Output<String>,
    public val storageAccountKey: Output<String>? = null,
    public val storageAccountName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.AzureFileVolumeArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.AzureFileVolumeArgs =
        com.pulumi.azurenative.containerinstance.inputs.AzureFileVolumeArgs.builder()
            .readOnly(readOnly?.applyValue({ args0 -> args0 }))
            .shareName(shareName.applyValue({ args0 -> args0 }))
            .storageAccountKey(storageAccountKey?.applyValue({ args0 -> args0 }))
            .storageAccountName(storageAccountName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFileVolumeArgs].
 */
@PulumiTagMarker
public class AzureFileVolumeArgsBuilder internal constructor() {
    private var readOnly: Output<Boolean>? = null

    private var shareName: Output<String>? = null

    private var storageAccountKey: Output<String>? = null

    private var storageAccountName: Output<String>? = null

    /**
     * @param value The flag indicating whether the Azure File shared mounted as a volume is read-only.
     */
    @JvmName("wibmugvddutxival")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value The name of the Azure File share to be mounted as a volume.
     */
    @JvmName("dnssitfoxxeblspi")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value The storage account access key used to access the Azure File share.
     */
    @JvmName("iibvkglxwqhbmvss")
    public suspend fun storageAccountKey(`value`: Output<String>) {
        this.storageAccountKey = value
    }

    /**
     * @param value The name of the storage account that contains the Azure File share.
     */
    @JvmName("shytmioiyuekwcnv")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value The flag indicating whether the Azure File shared mounted as a volume is read-only.
     */
    @JvmName("rikdkvvtpfuarkeg")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    /**
     * @param value The name of the Azure File share to be mounted as a volume.
     */
    @JvmName("dlickhqnycfcuctj")
    public suspend fun shareName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    /**
     * @param value The storage account access key used to access the Azure File share.
     */
    @JvmName("wjnklkclmrgaevia")
    public suspend fun storageAccountKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountKey = mapped
    }

    /**
     * @param value The name of the storage account that contains the Azure File share.
     */
    @JvmName("luxxynkislpbjhdj")
    public suspend fun storageAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    internal fun build(): AzureFileVolumeArgs = AzureFileVolumeArgs(
        readOnly = readOnly,
        shareName = shareName ?: throw PulumiNullFieldException("shareName"),
        storageAccountKey = storageAccountKey,
        storageAccountName = storageAccountName ?: throw PulumiNullFieldException("storageAccountName"),
    )
}
