@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.ConfidentialComputePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties for confidential container group
 * @property ccePolicy The base64 encoded confidential compute enforcement policy
 */
public data class ConfidentialComputePropertiesArgs(
    public val ccePolicy: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.ConfidentialComputePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerinstance.inputs.ConfidentialComputePropertiesArgs =
        com.pulumi.azurenative.containerinstance.inputs.ConfidentialComputePropertiesArgs.builder()
            .ccePolicy(ccePolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfidentialComputePropertiesArgs].
 */
@PulumiTagMarker
public class ConfidentialComputePropertiesArgsBuilder internal constructor() {
    private var ccePolicy: Output<String>? = null

    /**
     * @param value The base64 encoded confidential compute enforcement policy
     */
    @JvmName("ijarfquritcvjuuf")
    public suspend fun ccePolicy(`value`: Output<String>) {
        this.ccePolicy = value
    }

    /**
     * @param value The base64 encoded confidential compute enforcement policy
     */
    @JvmName("rqdkfvceffgpxolf")
    public suspend fun ccePolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ccePolicy = mapped
    }

    internal fun build(): ConfidentialComputePropertiesArgs = ConfidentialComputePropertiesArgs(
        ccePolicy = ccePolicy,
    )
}
