@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.ContainerGroupDiagnosticsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Container group diagnostic information.
 * @property logAnalytics Container group log analytics information.
 */
public data class ContainerGroupDiagnosticsArgs(
    public val logAnalytics: Output<LogAnalyticsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.ContainerGroupDiagnosticsArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerinstance.inputs.ContainerGroupDiagnosticsArgs =
        com.pulumi.azurenative.containerinstance.inputs.ContainerGroupDiagnosticsArgs.builder()
            .logAnalytics(logAnalytics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ContainerGroupDiagnosticsArgs].
 */
@PulumiTagMarker
public class ContainerGroupDiagnosticsArgsBuilder internal constructor() {
    private var logAnalytics: Output<LogAnalyticsArgs>? = null

    /**
     * @param value Container group log analytics information.
     */
    @JvmName("qymqscbughqeyxxg")
    public suspend fun logAnalytics(`value`: Output<LogAnalyticsArgs>) {
        this.logAnalytics = value
    }

    /**
     * @param value Container group log analytics information.
     */
    @JvmName("ejkwukomlbujyvjc")
    public suspend fun logAnalytics(`value`: LogAnalyticsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logAnalytics = mapped
    }

    /**
     * @param argument Container group log analytics information.
     */
    @JvmName("ryrwoxrxdgxrdiyn")
    public suspend fun logAnalytics(argument: suspend LogAnalyticsArgsBuilder.() -> Unit) {
        val toBeMapped = LogAnalyticsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logAnalytics = mapped
    }

    internal fun build(): ContainerGroupDiagnosticsArgs = ContainerGroupDiagnosticsArgs(
        logAnalytics = logAnalytics,
    )
}
