@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.ContainerPortArgs.builder
import com.pulumi.azurenative.containerinstance.kotlin.enums.ContainerNetworkProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The port exposed on the container instance.
 * @property port The port number exposed within the container group.
 * @property protocol The protocol associated with the port.
 */
public data class ContainerPortArgs(
    public val port: Output<Int>,
    public val protocol: Output<Either<String, ContainerNetworkProtocol>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.ContainerPortArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.ContainerPortArgs =
        com.pulumi.azurenative.containerinstance.inputs.ContainerPortArgs.builder()
            .port(port.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerPortArgs].
 */
@PulumiTagMarker
public class ContainerPortArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var protocol: Output<Either<String, ContainerNetworkProtocol>>? = null

    /**
     * @param value The port number exposed within the container group.
     */
    @JvmName("japuckqnmfiexvmy")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The protocol associated with the port.
     */
    @JvmName("cryaqdvpnbrlpxgv")
    public suspend fun protocol(`value`: Output<Either<String, ContainerNetworkProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The port number exposed within the container group.
     */
    @JvmName("kwkdlvcqmiyatfkg")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The protocol associated with the port.
     */
    @JvmName("jypycjrggyxnevek")
    public suspend fun protocol(`value`: Either<String, ContainerNetworkProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol associated with the port.
     */
    @JvmName("waecheiorflaycui")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContainerNetworkProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol associated with the port.
     */
    @JvmName("dvorkthnbkfwvjrl")
    public fun protocol(`value`: ContainerNetworkProtocol) {
        val toBeMapped = Either.ofRight<String, ContainerNetworkProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): ContainerPortArgs = ContainerPortArgs(
        port = port ?: throw PulumiNullFieldException("port"),
        protocol = protocol,
    )
}
