@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.DeploymentExtensionSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Extension sidecars to be added to the deployment.
 * @property extensionType Type of extension to be added.
 * @property name Name of the extension.
 * @property protectedSettings Protected settings for the extension.
 * @property settings Settings for the extension.
 * @property version Version of the extension being used.
 */
public data class DeploymentExtensionSpecArgs(
    public val extensionType: Output<String>,
    public val name: Output<String>,
    public val protectedSettings: Output<Any>? = null,
    public val settings: Output<Any>? = null,
    public val version: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.DeploymentExtensionSpecArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.DeploymentExtensionSpecArgs =
        com.pulumi.azurenative.containerinstance.inputs.DeploymentExtensionSpecArgs.builder()
            .extensionType(extensionType.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .protectedSettings(protectedSettings?.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0 }))
            .version(version.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentExtensionSpecArgs].
 */
@PulumiTagMarker
public class DeploymentExtensionSpecArgsBuilder internal constructor() {
    private var extensionType: Output<String>? = null

    private var name: Output<String>? = null

    private var protectedSettings: Output<Any>? = null

    private var settings: Output<Any>? = null

    private var version: Output<String>? = null

    /**
     * @param value Type of extension to be added.
     */
    @JvmName("mqhxxihoaastllii")
    public suspend fun extensionType(`value`: Output<String>) {
        this.extensionType = value
    }

    /**
     * @param value Name of the extension.
     */
    @JvmName("idsspjqyrsmyxthu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Protected settings for the extension.
     */
    @JvmName("thauygmihceqnjyx")
    public suspend fun protectedSettings(`value`: Output<Any>) {
        this.protectedSettings = value
    }

    /**
     * @param value Settings for the extension.
     */
    @JvmName("wxkxjirwgsfandai")
    public suspend fun settings(`value`: Output<Any>) {
        this.settings = value
    }

    /**
     * @param value Version of the extension being used.
     */
    @JvmName("lmdmhehmcpgadtkj")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Type of extension to be added.
     */
    @JvmName("jeeyfwqsddnxvxfg")
    public suspend fun extensionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extensionType = mapped
    }

    /**
     * @param value Name of the extension.
     */
    @JvmName("tyxmxfvjasjtdsxt")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Protected settings for the extension.
     */
    @JvmName("xegxumqlqovvyscq")
    public suspend fun protectedSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettings = mapped
    }

    /**
     * @param value Settings for the extension.
     */
    @JvmName("bbsoictqgmtraxtw")
    public suspend fun settings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value Version of the extension being used.
     */
    @JvmName("dviwjeogcjuhiiey")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): DeploymentExtensionSpecArgs = DeploymentExtensionSpecArgs(
        extensionType = extensionType ?: throw PulumiNullFieldException("extensionType"),
        name = name ?: throw PulumiNullFieldException("name"),
        protectedSettings = protectedSettings,
        settings = settings,
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
