@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.DnsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * DNS configuration for the container group.
 * @property nameServers The DNS servers for the container group.
 * @property options The DNS options for the container group.
 * @property searchDomains The DNS search domains for hostname lookup in the container group.
 */
public data class DnsConfigurationArgs(
    public val nameServers: Output<List<String>>,
    public val options: Output<String>? = null,
    public val searchDomains: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.DnsConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.DnsConfigurationArgs =
        com.pulumi.azurenative.containerinstance.inputs.DnsConfigurationArgs.builder()
            .nameServers(nameServers.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .options(options?.applyValue({ args0 -> args0 }))
            .searchDomains(searchDomains?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DnsConfigurationArgs].
 */
@PulumiTagMarker
public class DnsConfigurationArgsBuilder internal constructor() {
    private var nameServers: Output<List<String>>? = null

    private var options: Output<String>? = null

    private var searchDomains: Output<String>? = null

    /**
     * @param value The DNS servers for the container group.
     */
    @JvmName("vdxsdkivbcwofync")
    public suspend fun nameServers(`value`: Output<List<String>>) {
        this.nameServers = value
    }

    @JvmName("chnvktvxmvlqqtnk")
    public suspend fun nameServers(vararg values: Output<String>) {
        this.nameServers = Output.all(values.asList())
    }

    /**
     * @param values The DNS servers for the container group.
     */
    @JvmName("evmakmnosipxwdrx")
    public suspend fun nameServers(values: List<Output<String>>) {
        this.nameServers = Output.all(values)
    }

    /**
     * @param value The DNS options for the container group.
     */
    @JvmName("acpyqjjxnrcvbatg")
    public suspend fun options(`value`: Output<String>) {
        this.options = value
    }

    /**
     * @param value The DNS search domains for hostname lookup in the container group.
     */
    @JvmName("cxbqqfnrbjilpywd")
    public suspend fun searchDomains(`value`: Output<String>) {
        this.searchDomains = value
    }

    /**
     * @param value The DNS servers for the container group.
     */
    @JvmName("jdgymwtfydxmavwj")
    public suspend fun nameServers(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nameServers = mapped
    }

    /**
     * @param values The DNS servers for the container group.
     */
    @JvmName("wtegvsxpbxmeudxi")
    public suspend fun nameServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nameServers = mapped
    }

    /**
     * @param value The DNS options for the container group.
     */
    @JvmName("togqyjlwqwicduxk")
    public suspend fun options(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param value The DNS search domains for hostname lookup in the container group.
     */
    @JvmName("vmyqjlrqrbfggdqa")
    public suspend fun searchDomains(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchDomains = mapped
    }

    internal fun build(): DnsConfigurationArgs = DnsConfigurationArgs(
        nameServers = nameServers ?: throw PulumiNullFieldException("nameServers"),
        options = options,
        searchDomains = searchDomains,
    )
}
