@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * The instance view of the container instance. Only valid in response.
 * @property currentState Current container instance state.
 * @property events The events of the container instance.
 * @property previousState Previous container instance state.
 * @property restartCount The number of times that the container instance has been restarted.
 */
public data class ContainerPropertiesResponseInstanceView(
    public val currentState: ContainerStateResponse,
    public val events: List<EventResponse>,
    public val previousState: ContainerStateResponse,
    public val restartCount: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.ContainerPropertiesResponseInstanceView):
            ContainerPropertiesResponseInstanceView = ContainerPropertiesResponseInstanceView(
            currentState = javaType.currentState().let({ args0 ->
                com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerStateResponse.Companion.toKotlin(args0)
            }),
            events = javaType.events().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.EventResponse.Companion.toKotlin(args0)
                })
            }),
            previousState = javaType.previousState().let({ args0 ->
                com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerStateResponse.Companion.toKotlin(args0)
            }),
            restartCount = javaType.restartCount(),
        )
    }
}
