@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The GPU resource.
 * @property count The count of the GPU resource.
 * @property sku The SKU of the GPU resource.
 */
public data class GpuResourceResponse(
    public val count: Int,
    public val sku: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.GpuResourceResponse):
            GpuResourceResponse = GpuResourceResponse(
            count = javaType.count(),
            sku = javaType.sku(),
        )
    }
}
