@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The properties of the volume.
 * @property azureFile The Azure File volume.
 * @property emptyDir The empty directory volume.
 * @property gitRepo The git repo volume.
 * @property name The name of the volume.
 * @property secret The secret volume.
 */
public data class VolumeResponse(
    public val azureFile: AzureFileVolumeResponse? = null,
    public val emptyDir: Any? = null,
    public val gitRepo: GitRepoVolumeResponse? = null,
    public val name: String,
    public val secret: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.VolumeResponse):
            VolumeResponse = VolumeResponse(
            azureFile = javaType.azureFile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.AzureFileVolumeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            emptyDir = javaType.emptyDir().map({ args0 -> args0 }).orElse(null),
            gitRepo = javaType.gitRepo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.GitRepoVolumeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            secret = javaType.secret().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
