@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.kotlin.outputs.ActivationPropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.LoggingPropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.LoginServerPropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ParentPropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.StatusDetailPropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ActivationPropertiesResponse.Companion.toKotlin as activationPropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.LoggingPropertiesResponse.Companion.toKotlin as loggingPropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.LoginServerPropertiesResponse.Companion.toKotlin as loginServerPropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ParentPropertiesResponse.Companion.toKotlin as parentPropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.StatusDetailPropertiesResponse.Companion.toKotlin as statusDetailPropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConnectedRegistry].
 */
@PulumiTagMarker
public class ConnectedRegistryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectedRegistryArgs = ConnectedRegistryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectedRegistryArgsBuilder.() -> Unit) {
        val builder = ConnectedRegistryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConnectedRegistry {
        val builtJavaResource =
            com.pulumi.azurenative.containerregistry.ConnectedRegistry(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConnectedRegistry(builtJavaResource)
    }
}

/**
 * An object that represents a connected registry for a container registry.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### ConnectedRegistryCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectedRegistry = new AzureNative.ContainerRegistry.ConnectedRegistry("connectedRegistry", new()
 *     {
 *         ClientTokenIds = new[]
 *         {
 *             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/tokens/client1Token",
 *         },
 *         ConnectedRegistryName = "myConnectedRegistry",
 *         Mode = "ReadWrite",
 *         NotificationsList = new[]
 *         {
 *             "hello-world:*:*",
 *             "sample/repo/*:1.0:*",
 *         },
 *         Parent = new AzureNative.ContainerRegistry.Inputs.ParentPropertiesArgs
 *         {
 *             SyncProperties = new AzureNative.ContainerRegistry.Inputs.SyncPropertiesArgs
 *             {
 *                 MessageTtl = "P2D",
 *                 Schedule = "0 9 * * *",
 *                 SyncWindow = "PT3H",
 *                 TokenId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/tokens/syncToken",
 *             },
 *         },
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewConnectedRegistry(ctx, "connectedRegistry", &containerregistry.ConnectedRegistryArgs{
 * 			ClientTokenIds: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/tokens/client1Token"),
 * 			},
 * 			ConnectedRegistryName: pulumi.String("myConnectedRegistry"),
 * 			Mode:                  pulumi.String("ReadWrite"),
 * 			NotificationsList: pulumi.StringArray{
 * 				pulumi.String("hello-world:*:*"),
 * 				pulumi.String("sample/repo/*:1.0:*"),
 * 			},
 * 			Parent: containerregistry.ParentPropertiesResponse{
 * 				SyncProperties: &containerregistry.SyncPropertiesArgs{
 * 					MessageTtl: pulumi.String("P2D"),
 * 					Schedule:   pulumi.String("0 9 * * *"),
 * 					SyncWindow: pulumi.String("PT3H"),
 * 					TokenId:    pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/tokens/syncToken"),
 * 				},
 * 			},
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.ConnectedRegistry;
 * import com.pulumi.azurenative.containerregistry.ConnectedRegistryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectedRegistry = new ConnectedRegistry("connectedRegistry", ConnectedRegistryArgs.builder()
 *             .clientTokenIds("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/tokens/client1Token")
 *             .connectedRegistryName("myConnectedRegistry")
 *             .mode("ReadWrite")
 *             .notificationsList(
 *                 "hello-world:*:*",
 *                 "sample/repo/*:1.0:*")
 *             .parent(Map.of("syncProperties", Map.ofEntries(
 *                 Map.entry("messageTtl", "P2D"),
 *                 Map.entry("schedule", "0 9 * * *"),
 *                 Map.entry("syncWindow", "PT3H"),
 *                 Map.entry("tokenId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/tokens/syncToken")
 *             )))
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:ConnectedRegistry myConnectedRegistry /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/connectedRegistries/{connectedRegistryName}
 * ```
 * */*/*/
 */
public class ConnectedRegistry internal constructor(
    override val javaResource: com.pulumi.azurenative.containerregistry.ConnectedRegistry,
) : KotlinCustomResource(javaResource, ConnectedRegistryMapper) {
    /**
     * The activation properties of the connected registry.
     */
    public val activation: Output<ActivationPropertiesResponse>
        get() = javaResource.activation().applyValue({ args0 ->
            args0.let({ args0 ->
                activationPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The list of the ACR token resource IDs used to authenticate clients to the connected registry.
     */
    public val clientTokenIds: Output<List<String>>?
        get() = javaResource.clientTokenIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The current connection state of the connected registry.
     */
    public val connectionState: Output<String>
        get() = javaResource.connectionState().applyValue({ args0 -> args0 })

    /**
     * The last activity time of the connected registry.
     */
    public val lastActivityTime: Output<String>
        get() = javaResource.lastActivityTime().applyValue({ args0 -> args0 })

    /**
     * The logging properties of the connected registry.
     */
    public val logging: Output<LoggingPropertiesResponse>?
        get() = javaResource.logging().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    loggingPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The login server properties of the connected registry.
     */
    public val loginServer: Output<LoginServerPropertiesResponse>?
        get() = javaResource.loginServer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    loginServerPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The mode of the connected registry resource that indicates the permissions of the registry.
     */
    public val mode: Output<String>
        get() = javaResource.mode().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of notifications subscription information for the connected registry.
     */
    public val notificationsList: Output<List<String>>?
        get() = javaResource.notificationsList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The parent of the connected registry.
     */
    public val parent: Output<ParentPropertiesResponse>
        get() = javaResource.parent().applyValue({ args0 ->
            args0.let({ args0 ->
                parentPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The list of current statuses of the connected registry.
     */
    public val statusDetails: Output<List<StatusDetailPropertiesResponse>>
        get() = javaResource.statusDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> statusDetailPropertiesResponseToKotlin(args0) })
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The current version of ACR runtime on the connected registry.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object ConnectedRegistryMapper : ResourceMapper<ConnectedRegistry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerregistry.ConnectedRegistry::class == javaResource::class

    override fun map(javaResource: Resource): ConnectedRegistry = ConnectedRegistry(
        javaResource as
            com.pulumi.azurenative.containerregistry.ConnectedRegistry,
    )
}

/**
 * @see [ConnectedRegistry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectedRegistry].
 */
public suspend fun connectedRegistry(
    name: String,
    block: suspend ConnectedRegistryResourceBuilder.() -> Unit,
): ConnectedRegistry {
    val builder = ConnectedRegistryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectedRegistry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectedRegistry(name: String): ConnectedRegistry {
    val builder = ConnectedRegistryResourceBuilder()
    builder.name(name)
    return builder.build()
}
