@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.ImportPipelineArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.PipelineOptions
import com.pulumi.azurenative.containerregistry.kotlin.inputs.IdentityPropertiesArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.IdentityPropertiesArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ImportPipelineSourcePropertiesArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ImportPipelineSourcePropertiesArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.PipelineTriggerPropertiesArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.PipelineTriggerPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An object that represents an import pipeline for a container registry.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### ImportPipelineCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var importPipeline = new AzureNative.ContainerRegistry.ImportPipeline("importPipeline", new()
 *     {
 *         Identity = new AzureNative.ContainerRegistry.Inputs.IdentityPropertiesArgs
 *         {
 *             Type = AzureNative.ContainerRegistry.ResourceIdentityType.UserAssigned,
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2", null },
 *             },
 *         },
 *         ImportPipelineName = "myImportPipeline",
 *         Location = "westus",
 *         Options = new[]
 *         {
 *             "OverwriteTags",
 *             "DeleteSourceBlobOnSuccess",
 *             "ContinueOnErrors",
 *         },
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Source = new AzureNative.ContainerRegistry.Inputs.ImportPipelineSourcePropertiesArgs
 *         {
 *             KeyVaultUri = "https://myvault.vault.azure.net/secrets/acrimportsas",
 *             Type = "AzureStorageBlobContainer",
 *             Uri = "https://accountname.blob.core.windows.net/containername",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewImportPipeline(ctx, "importPipeline", &containerregistry.ImportPipelineArgs{
 * 			Identity: containerregistry.IdentityPropertiesResponse{
 * 				Type: containerregistry.ResourceIdentityTypeUserAssigned,
 * 				UserAssignedIdentities: containerregistry.UserIdentityPropertiesMap{
 * 					"/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2": nil,
 * 				},
 * 			},
 * 			ImportPipelineName: pulumi.String("myImportPipeline"),
 * 			Location:           pulumi.String("westus"),
 * 			Options: pulumi.StringArray{
 * 				pulumi.String("OverwriteTags"),
 * 				pulumi.String("DeleteSourceBlobOnSuccess"),
 * 				pulumi.String("ContinueOnErrors"),
 * 			},
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Source: &containerregistry.ImportPipelineSourcePropertiesArgs{
 * 				KeyVaultUri: pulumi.String("https://myvault.vault.azure.net/secrets/acrimportsas"),
 * 				Type:        pulumi.String("AzureStorageBlobContainer"),
 * 				Uri:         pulumi.String("https://accountname.blob.core.windows.net/containername"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.ImportPipeline;
 * import com.pulumi.azurenative.containerregistry.ImportPipelineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var importPipeline = new ImportPipeline("importPipeline", ImportPipelineArgs.builder()
 *             .identity(Map.ofEntries(
 *                 Map.entry("type", "UserAssigned"),
 *                 Map.entry("userAssignedIdentities", Map.of("/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2", ))
 *             ))
 *             .importPipelineName("myImportPipeline")
 *             .location("westus")
 *             .options(
 *                 "OverwriteTags",
 *                 "DeleteSourceBlobOnSuccess",
 *                 "ContinueOnErrors")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .source(Map.ofEntries(
 *                 Map.entry("keyVaultUri", "https://myvault.vault.azure.net/secrets/acrimportsas"),
 *                 Map.entry("type", "AzureStorageBlobContainer"),
 *                 Map.entry("uri", "https://accountname.blob.core.windows.net/containername")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:ImportPipeline myImportPipeline /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/importPipelines/{importPipelineName}
 * ```
 * @property identity The identity of the import pipeline.
 * @property importPipelineName The name of the import pipeline.
 * @property location The location of the import pipeline.
 * @property options The list of all options configured for the pipeline.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property source The source properties of the import pipeline.
 * @property trigger The properties that describe the trigger of the import pipeline.
 */
public data class ImportPipelineArgs(
    public val identity: Output<IdentityPropertiesArgs>? = null,
    public val importPipelineName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val options: Output<List<Either<String, PipelineOptions>>>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<ImportPipelineSourcePropertiesArgs>? = null,
    public val trigger: Output<PipelineTriggerPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.ImportPipelineArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.ImportPipelineArgs =
        com.pulumi.azurenative.containerregistry.ImportPipelineArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .importPipelineName(importPipelineName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .options(
                options?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trigger(trigger?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ImportPipelineArgs].
 */
@PulumiTagMarker
public class ImportPipelineArgsBuilder internal constructor() {
    private var identity: Output<IdentityPropertiesArgs>? = null

    private var importPipelineName: Output<String>? = null

    private var location: Output<String>? = null

    private var options: Output<List<Either<String, PipelineOptions>>>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<ImportPipelineSourcePropertiesArgs>? = null

    private var trigger: Output<PipelineTriggerPropertiesArgs>? = null

    /**
     * @param value The identity of the import pipeline.
     */
    @JvmName("mwlwygwpdtpaqumt")
    public suspend fun identity(`value`: Output<IdentityPropertiesArgs>) {
        this.identity = value
    }

    /**
     * @param value The name of the import pipeline.
     */
    @JvmName("hjjqeegvbatfhspb")
    public suspend fun importPipelineName(`value`: Output<String>) {
        this.importPipelineName = value
    }

    /**
     * @param value The location of the import pipeline.
     */
    @JvmName("qprhoaneknrfucld")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The list of all options configured for the pipeline.
     */
    @JvmName("hmpcjiuictqrctac")
    public suspend fun options(`value`: Output<List<Either<String, PipelineOptions>>>) {
        this.options = value
    }

    @JvmName("vtydkgkxuhkpaiea")
    public suspend fun options(vararg values: Output<Either<String, PipelineOptions>>) {
        this.options = Output.all(values.asList())
    }

    /**
     * @param values The list of all options configured for the pipeline.
     */
    @JvmName("gkbeveydvwguphus")
    public suspend fun options(values: List<Output<Either<String, PipelineOptions>>>) {
        this.options = Output.all(values)
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("ugehprsosdniqrcn")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("imvwnrjlhdkwjwjw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The source properties of the import pipeline.
     */
    @JvmName("xhfdnfvxdgulletr")
    public suspend fun source(`value`: Output<ImportPipelineSourcePropertiesArgs>) {
        this.source = value
    }

    /**
     * @param value The properties that describe the trigger of the import pipeline.
     */
    @JvmName("ogwfyptuxixkkece")
    public suspend fun trigger(`value`: Output<PipelineTriggerPropertiesArgs>) {
        this.trigger = value
    }

    /**
     * @param value The identity of the import pipeline.
     */
    @JvmName("wbmpkbpnuwuoixts")
    public suspend fun identity(`value`: IdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the import pipeline.
     */
    @JvmName("htkvgfaasocahdkw")
    public suspend fun identity(argument: suspend IdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The name of the import pipeline.
     */
    @JvmName("opfenbkccccpoiyx")
    public suspend fun importPipelineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importPipelineName = mapped
    }

    /**
     * @param value The location of the import pipeline.
     */
    @JvmName("phewahmmqypngurx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The list of all options configured for the pipeline.
     */
    @JvmName("jomclvelverwivdp")
    public suspend fun options(`value`: List<Either<String, PipelineOptions>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param values The list of all options configured for the pipeline.
     */
    @JvmName("qmheqvfwloplpmjt")
    public suspend fun options(vararg values: Either<String, PipelineOptions>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("cikllvayehbkhbgb")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("auyjwllpilgxjxyr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The source properties of the import pipeline.
     */
    @JvmName("ekchjmsmfwoiqyqh")
    public suspend fun source(`value`: ImportPipelineSourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument The source properties of the import pipeline.
     */
    @JvmName("didgwoqbfwkgomvb")
    public suspend
    fun source(argument: suspend ImportPipelineSourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ImportPipelineSourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value The properties that describe the trigger of the import pipeline.
     */
    @JvmName("wktupdtxmkrsblah")
    public suspend fun trigger(`value`: PipelineTriggerPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trigger = mapped
    }

    /**
     * @param argument The properties that describe the trigger of the import pipeline.
     */
    @JvmName("kxwolpeckcilvigv")
    public suspend fun trigger(argument: suspend PipelineTriggerPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineTriggerPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trigger = mapped
    }

    internal fun build(): ImportPipelineArgs = ImportPipelineArgs(
        identity = identity,
        importPipelineName = importPipelineName,
        location = location,
        options = options,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
        source = source,
        trigger = trigger,
    )
}
