@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.kotlin.outputs.PipelineRunRequestResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.PipelineRunResponseResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.containerregistry.kotlin.outputs.PipelineRunRequestResponse.Companion.toKotlin as pipelineRunRequestResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.PipelineRunResponseResponse.Companion.toKotlin as pipelineRunResponseResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PipelineRun].
 */
@PulumiTagMarker
public class PipelineRunResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipelineRunArgs = PipelineRunArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipelineRunArgsBuilder.() -> Unit) {
        val builder = PipelineRunArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PipelineRun {
        val builtJavaResource =
            com.pulumi.azurenative.containerregistry.PipelineRun(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PipelineRun(builtJavaResource)
    }
}

/**
 * An object that represents a pipeline run for a container registry.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### PipelineRunCreate_Export
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pipelineRun = new AzureNative.ContainerRegistry.PipelineRun("pipelineRun", new()
 *     {
 *         PipelineRunName = "myPipelineRun",
 *         RegistryName = "myRegistry",
 *         Request = new AzureNative.ContainerRegistry.Inputs.PipelineRunRequestArgs
 *         {
 *             Artifacts = new[]
 *             {
 *                 "sourceRepository/hello-world",
 *                 "sourceRepository2@sha256:00000000000000000000000000000000000",
 *             },
 *             PipelineResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/exportPipelines/myExportPipeline",
 *             Target = new AzureNative.ContainerRegistry.Inputs.PipelineRunTargetPropertiesArgs
 *             {
 *                 Name = "myblob.tar.gz",
 *                 Type = "AzureStorageBlob",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewPipelineRun(ctx, "pipelineRun", &containerregistry.PipelineRunArgs{
 * 			PipelineRunName: pulumi.String("myPipelineRun"),
 * 			RegistryName:    pulumi.String("myRegistry"),
 * 			Request: containerregistry.PipelineRunRequestResponse{
 * 				Artifacts: pulumi.StringArray{
 * 					pulumi.String("sourceRepository/hello-world"),
 * 					pulumi.String("sourceRepository2@sha256:00000000000000000000000000000000000"),
 * 				},
 * 				PipelineResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/exportPipelines/myExportPipeline"),
 * 				Target: &containerregistry.PipelineRunTargetPropertiesArgs{
 * 					Name: pulumi.String("myblob.tar.gz"),
 * 					Type: pulumi.String("AzureStorageBlob"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.PipelineRun;
 * import com.pulumi.azurenative.containerregistry.PipelineRunArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pipelineRun = new PipelineRun("pipelineRun", PipelineRunArgs.builder()
 *             .pipelineRunName("myPipelineRun")
 *             .registryName("myRegistry")
 *             .request(Map.ofEntries(
 *                 Map.entry("artifacts",
 *                     "sourceRepository/hello-world",
 *                     "sourceRepository2@sha256:00000000000000000000000000000000000"),
 *                 Map.entry("pipelineResourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/exportPipelines/myExportPipeline"),
 *                 Map.entry("target", Map.ofEntries(
 *                     Map.entry("name", "myblob.tar.gz"),
 *                     Map.entry("type", "AzureStorageBlob")
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### PipelineRunCreate_Import
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pipelineRun = new AzureNative.ContainerRegistry.PipelineRun("pipelineRun", new()
 *     {
 *         ForceUpdateTag = "2020-03-04T17:23:21.9261521+00:00",
 *         PipelineRunName = "myPipelineRun",
 *         RegistryName = "myRegistry",
 *         Request = new AzureNative.ContainerRegistry.Inputs.PipelineRunRequestArgs
 *         {
 *             CatalogDigest = "sha256@",
 *             PipelineResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/importPipelines/myImportPipeline",
 *             Source = new AzureNative.ContainerRegistry.Inputs.PipelineRunSourcePropertiesArgs
 *             {
 *                 Name = "myblob.tar.gz",
 *                 Type = "AzureStorageBlob",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewPipelineRun(ctx, "pipelineRun", &containerregistry.PipelineRunArgs{
 * 			ForceUpdateTag:  pulumi.String("2020-03-04T17:23:21.9261521+00:00"),
 * 			PipelineRunName: pulumi.String("myPipelineRun"),
 * 			RegistryName:    pulumi.String("myRegistry"),
 * 			Request: containerregistry.PipelineRunRequestResponse{
 * 				CatalogDigest:      pulumi.String("sha256@"),
 * 				PipelineResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/importPipelines/myImportPipeline"),
 * 				Source: &containerregistry.PipelineRunSourcePropertiesArgs{
 * 					Name: pulumi.String("myblob.tar.gz"),
 * 					Type: pulumi.String("AzureStorageBlob"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.PipelineRun;
 * import com.pulumi.azurenative.containerregistry.PipelineRunArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pipelineRun = new PipelineRun("pipelineRun", PipelineRunArgs.builder()
 *             .forceUpdateTag("2020-03-04T17:23:21.9261521+00:00")
 *             .pipelineRunName("myPipelineRun")
 *             .registryName("myRegistry")
 *             .request(Map.ofEntries(
 *                 Map.entry("catalogDigest", "sha256@"),
 *                 Map.entry("pipelineResourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/importPipelines/myImportPipeline"),
 *                 Map.entry("source", Map.ofEntries(
 *                     Map.entry("name", "myblob.tar.gz"),
 *                     Map.entry("type", "AzureStorageBlob")
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:PipelineRun myPipelineRun /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/pipelineRuns/{pipelineRunName}
 * ```
 */
public class PipelineRun internal constructor(
    override val javaResource: com.pulumi.azurenative.containerregistry.PipelineRun,
) : KotlinCustomResource(javaResource, PipelineRunMapper) {
    /**
     * How the pipeline run should be forced to recreate even if the pipeline run configuration has not changed.
     */
    public val forceUpdateTag: Output<String>?
        get() = javaResource.forceUpdateTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of a pipeline run.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The request parameters for a pipeline run.
     */
    public val request: Output<PipelineRunRequestResponse>?
        get() = javaResource.request().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    pipelineRunRequestResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The response of a pipeline run.
     */
    public val response: Output<PipelineRunResponseResponse>
        get() = javaResource.response().applyValue({ args0 ->
            args0.let({ args0 ->
                pipelineRunResponseResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PipelineRunMapper : ResourceMapper<PipelineRun> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerregistry.PipelineRun::class == javaResource::class

    override fun map(javaResource: Resource): PipelineRun = PipelineRun(
        javaResource as
            com.pulumi.azurenative.containerregistry.PipelineRun,
    )
}

/**
 * @see [PipelineRun].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PipelineRun].
 */
public suspend fun pipelineRun(name: String, block: suspend PipelineRunResourceBuilder.() -> Unit):
    PipelineRun {
    val builder = PipelineRunResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PipelineRun].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipelineRun(name: String): PipelineRun {
    val builder = PipelineRunResourceBuilder()
    builder.name(name)
    return builder.build()
}
