@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.PipelineRunArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.PipelineRunRequestArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.PipelineRunRequestArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * An object that represents a pipeline run for a container registry.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### PipelineRunCreate_Export
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pipelineRun = new AzureNative.ContainerRegistry.PipelineRun("pipelineRun", new()
 *     {
 *         PipelineRunName = "myPipelineRun",
 *         RegistryName = "myRegistry",
 *         Request = new AzureNative.ContainerRegistry.Inputs.PipelineRunRequestArgs
 *         {
 *             Artifacts = new[]
 *             {
 *                 "sourceRepository/hello-world",
 *                 "sourceRepository2@sha256:00000000000000000000000000000000000",
 *             },
 *             PipelineResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/exportPipelines/myExportPipeline",
 *             Target = new AzureNative.ContainerRegistry.Inputs.PipelineRunTargetPropertiesArgs
 *             {
 *                 Name = "myblob.tar.gz",
 *                 Type = "AzureStorageBlob",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewPipelineRun(ctx, "pipelineRun", &containerregistry.PipelineRunArgs{
 * 			PipelineRunName: pulumi.String("myPipelineRun"),
 * 			RegistryName:    pulumi.String("myRegistry"),
 * 			Request: containerregistry.PipelineRunRequestResponse{
 * 				Artifacts: pulumi.StringArray{
 * 					pulumi.String("sourceRepository/hello-world"),
 * 					pulumi.String("sourceRepository2@sha256:00000000000000000000000000000000000"),
 * 				},
 * 				PipelineResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/exportPipelines/myExportPipeline"),
 * 				Target: &containerregistry.PipelineRunTargetPropertiesArgs{
 * 					Name: pulumi.String("myblob.tar.gz"),
 * 					Type: pulumi.String("AzureStorageBlob"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.PipelineRun;
 * import com.pulumi.azurenative.containerregistry.PipelineRunArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pipelineRun = new PipelineRun("pipelineRun", PipelineRunArgs.builder()
 *             .pipelineRunName("myPipelineRun")
 *             .registryName("myRegistry")
 *             .request(Map.ofEntries(
 *                 Map.entry("artifacts",
 *                     "sourceRepository/hello-world",
 *                     "sourceRepository2@sha256:00000000000000000000000000000000000"),
 *                 Map.entry("pipelineResourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/exportPipelines/myExportPipeline"),
 *                 Map.entry("target", Map.ofEntries(
 *                     Map.entry("name", "myblob.tar.gz"),
 *                     Map.entry("type", "AzureStorageBlob")
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### PipelineRunCreate_Import
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pipelineRun = new AzureNative.ContainerRegistry.PipelineRun("pipelineRun", new()
 *     {
 *         ForceUpdateTag = "2020-03-04T17:23:21.9261521+00:00",
 *         PipelineRunName = "myPipelineRun",
 *         RegistryName = "myRegistry",
 *         Request = new AzureNative.ContainerRegistry.Inputs.PipelineRunRequestArgs
 *         {
 *             CatalogDigest = "sha256@",
 *             PipelineResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/importPipelines/myImportPipeline",
 *             Source = new AzureNative.ContainerRegistry.Inputs.PipelineRunSourcePropertiesArgs
 *             {
 *                 Name = "myblob.tar.gz",
 *                 Type = "AzureStorageBlob",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewPipelineRun(ctx, "pipelineRun", &containerregistry.PipelineRunArgs{
 * 			ForceUpdateTag:  pulumi.String("2020-03-04T17:23:21.9261521+00:00"),
 * 			PipelineRunName: pulumi.String("myPipelineRun"),
 * 			RegistryName:    pulumi.String("myRegistry"),
 * 			Request: containerregistry.PipelineRunRequestResponse{
 * 				CatalogDigest:      pulumi.String("sha256@"),
 * 				PipelineResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/importPipelines/myImportPipeline"),
 * 				Source: &containerregistry.PipelineRunSourcePropertiesArgs{
 * 					Name: pulumi.String("myblob.tar.gz"),
 * 					Type: pulumi.String("AzureStorageBlob"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.PipelineRun;
 * import com.pulumi.azurenative.containerregistry.PipelineRunArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pipelineRun = new PipelineRun("pipelineRun", PipelineRunArgs.builder()
 *             .forceUpdateTag("2020-03-04T17:23:21.9261521+00:00")
 *             .pipelineRunName("myPipelineRun")
 *             .registryName("myRegistry")
 *             .request(Map.ofEntries(
 *                 Map.entry("catalogDigest", "sha256@"),
 *                 Map.entry("pipelineResourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/importPipelines/myImportPipeline"),
 *                 Map.entry("source", Map.ofEntries(
 *                     Map.entry("name", "myblob.tar.gz"),
 *                     Map.entry("type", "AzureStorageBlob")
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:PipelineRun myPipelineRun /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/pipelineRuns/{pipelineRunName}
 * ```
 * @property forceUpdateTag How the pipeline run should be forced to recreate even if the pipeline run configuration has not changed.
 * @property pipelineRunName The name of the pipeline run.
 * @property registryName The name of the container registry.
 * @property request The request parameters for a pipeline run.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class PipelineRunArgs(
    public val forceUpdateTag: Output<String>? = null,
    public val pipelineRunName: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val request: Output<PipelineRunRequestArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.PipelineRunArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.PipelineRunArgs =
        com.pulumi.azurenative.containerregistry.PipelineRunArgs.builder()
            .forceUpdateTag(forceUpdateTag?.applyValue({ args0 -> args0 }))
            .pipelineRunName(pipelineRunName?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .request(request?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineRunArgs].
 */
@PulumiTagMarker
public class PipelineRunArgsBuilder internal constructor() {
    private var forceUpdateTag: Output<String>? = null

    private var pipelineRunName: Output<String>? = null

    private var registryName: Output<String>? = null

    private var request: Output<PipelineRunRequestArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value How the pipeline run should be forced to recreate even if the pipeline run configuration has not changed.
     */
    @JvmName("soefpsltgxtcowhb")
    public suspend fun forceUpdateTag(`value`: Output<String>) {
        this.forceUpdateTag = value
    }

    /**
     * @param value The name of the pipeline run.
     */
    @JvmName("mcbcgmoqtymmtlva")
    public suspend fun pipelineRunName(`value`: Output<String>) {
        this.pipelineRunName = value
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("ygynsipddhcvgsju")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The request parameters for a pipeline run.
     */
    @JvmName("wptwrmqdxochovhj")
    public suspend fun request(`value`: Output<PipelineRunRequestArgs>) {
        this.request = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uiijjmktvnvnotea")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value How the pipeline run should be forced to recreate even if the pipeline run configuration has not changed.
     */
    @JvmName("usgjysxuhqdltqjj")
    public suspend fun forceUpdateTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdateTag = mapped
    }

    /**
     * @param value The name of the pipeline run.
     */
    @JvmName("rbgomnfalgqxdgsw")
    public suspend fun pipelineRunName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineRunName = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("okvnujhspeyqvnyp")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The request parameters for a pipeline run.
     */
    @JvmName("nfuclmelfmtdhrta")
    public suspend fun request(`value`: PipelineRunRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.request = mapped
    }

    /**
     * @param argument The request parameters for a pipeline run.
     */
    @JvmName("tnvtkdixtfjavgbe")
    public suspend fun request(argument: suspend PipelineRunRequestArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineRunRequestArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.request = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rqgoutchtrxxuqgk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PipelineRunArgs = PipelineRunArgs(
        forceUpdateTag = forceUpdateTag,
        pipelineRunName = pipelineRunName,
        registryName = registryName,
        request = request,
        resourceGroupName = resourceGroupName,
    )
}
