@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.ReplicationArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.ZoneRedundancy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An object that represents a replication for a container registry.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### ReplicationCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replication = new AzureNative.ContainerRegistry.Replication("replication", new()
 *     {
 *         Location = "eastus",
 *         RegistryName = "myRegistry",
 *         ReplicationName = "myReplication",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewReplication(ctx, "replication", &containerregistry.ReplicationArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ReplicationName:   pulumi.String("myReplication"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Replication;
 * import com.pulumi.azurenative.containerregistry.ReplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replication = new Replication("replication", ReplicationArgs.builder()
 *             .location("eastus")
 *             .registryName("myRegistry")
 *             .replicationName("myReplication")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("key", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ### ReplicationCreateZoneRedundant
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replication = new AzureNative.ContainerRegistry.Replication("replication", new()
 *     {
 *         Location = "eastus",
 *         RegionEndpointEnabled = true,
 *         RegistryName = "myRegistry",
 *         ReplicationName = "myReplication",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *         ZoneRedundancy = "Enabled",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewReplication(ctx, "replication", &containerregistry.ReplicationArgs{
 * 			Location:              pulumi.String("eastus"),
 * 			RegionEndpointEnabled: pulumi.Bool(true),
 * 			RegistryName:          pulumi.String("myRegistry"),
 * 			ReplicationName:       pulumi.String("myReplication"),
 * 			ResourceGroupName:     pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 			ZoneRedundancy: pulumi.String("Enabled"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Replication;
 * import com.pulumi.azurenative.containerregistry.ReplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replication = new Replication("replication", ReplicationArgs.builder()
 *             .location("eastus")
 *             .regionEndpointEnabled(true)
 *             .registryName("myRegistry")
 *             .replicationName("myReplication")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("key", "value"))
 *             .zoneRedundancy("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:Replication myReplication /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}
 * ```
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property regionEndpointEnabled Specifies whether the replication's regional endpoint is enabled. Requests will not be routed to a replication whose regional endpoint is disabled, however its data will continue to be synced with other replications.
 * @property registryName The name of the container registry.
 * @property replicationName The name of the replication.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags The tags of the resource.
 * @property zoneRedundancy Whether or not zone redundancy is enabled for this container registry replication
 */
public data class ReplicationArgs(
    public val location: Output<String>? = null,
    public val regionEndpointEnabled: Output<Boolean>? = null,
    public val registryName: Output<String>? = null,
    public val replicationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zoneRedundancy: Output<Either<String, ZoneRedundancy>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.ReplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.ReplicationArgs =
        com.pulumi.azurenative.containerregistry.ReplicationArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .regionEndpointEnabled(regionEndpointEnabled?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .replicationName(replicationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneRedundancy(
                zoneRedundancy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ReplicationArgs].
 */
@PulumiTagMarker
public class ReplicationArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var regionEndpointEnabled: Output<Boolean>? = null

    private var registryName: Output<String>? = null

    private var replicationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zoneRedundancy: Output<Either<String, ZoneRedundancy>>? = null

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("inhskqjorcdtplis")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Specifies whether the replication's regional endpoint is enabled. Requests will not be routed to a replication whose regional endpoint is disabled, however its data will continue to be synced with other replications.
     */
    @JvmName("ubtvnvxgtxskcqcm")
    public suspend fun regionEndpointEnabled(`value`: Output<Boolean>) {
        this.regionEndpointEnabled = value
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("okbkqmuagyrfpvhw")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the replication.
     */
    @JvmName("xjcgahsovteuqawd")
    public suspend fun replicationName(`value`: Output<String>) {
        this.replicationName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vbpqppmejounyeqp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("arggachaklepukla")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether or not zone redundancy is enabled for this container registry replication
     */
    @JvmName("liovslmotjwcxipy")
    public suspend fun zoneRedundancy(`value`: Output<Either<String, ZoneRedundancy>>) {
        this.zoneRedundancy = value
    }

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("rnmtvdrxfsnduilk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Specifies whether the replication's regional endpoint is enabled. Requests will not be routed to a replication whose regional endpoint is disabled, however its data will continue to be synced with other replications.
     */
    @JvmName("gnwrfhlrcqvynvay")
    public suspend fun regionEndpointEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionEndpointEnabled = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("ljfvpjwkoicpflic")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the replication.
     */
    @JvmName("fkcxfpaislmyamuy")
    public suspend fun replicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ulwxvqjkswllmdbf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("uvllryncuebrmrya")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("cjmhsduldriuqwoa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Whether or not zone redundancy is enabled for this container registry replication
     */
    @JvmName("efexcgiofvegkfcm")
    public suspend fun zoneRedundancy(`value`: Either<String, ZoneRedundancy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneRedundancy = mapped
    }

    /**
     * @param value Whether or not zone redundancy is enabled for this container registry replication
     */
    @JvmName("lswavpyjkrmggtwf")
    public fun zoneRedundancy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ZoneRedundancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneRedundancy = mapped
    }

    /**
     * @param value Whether or not zone redundancy is enabled for this container registry replication
     */
    @JvmName("virpaoyhalkjkqwj")
    public fun zoneRedundancy(`value`: ZoneRedundancy) {
        val toBeMapped = Either.ofRight<String, ZoneRedundancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneRedundancy = mapped
    }

    internal fun build(): ReplicationArgs = ReplicationArgs(
        location = location,
        regionEndpointEnabled = regionEndpointEnabled,
        registryName = registryName,
        replicationName = replicationName,
        resourceGroupName = resourceGroupName,
        tags = tags,
        zoneRedundancy = zoneRedundancy,
    )
}
