@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.EncodedTaskRunRequestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The parameters for a quick task run request.
 * @property agentConfiguration The machine configuration of the run agent.
 * @property agentPoolName The dedicated agent pool for the run.
 * @property credentials The properties that describes a set of credentials that will be used when this run is invoked.
 * @property encodedTaskContent Base64 encoded value of the template/definition file content.
 * @property encodedValuesContent Base64 encoded value of the parameters/values file content.
 * @property isArchiveEnabled The value that indicates whether archiving is enabled for the run or not.
 * @property logTemplate The template that describes the repository and tag information for run log artifact.
 * @property platform The platform properties against which the run has to happen.
 * @property sourceLocation The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
 * If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
 * @property timeout Run timeout in seconds.
 * @property type The type of the run request.
 * Expected value is 'EncodedTaskRunRequest'.
 * @property values The collection of overridable values that can be passed when running a task.
 */
public data class EncodedTaskRunRequestArgs(
    public val agentConfiguration: Output<AgentPropertiesArgs>? = null,
    public val agentPoolName: Output<String>? = null,
    public val credentials: Output<CredentialsArgs>? = null,
    public val encodedTaskContent: Output<String>,
    public val encodedValuesContent: Output<String>? = null,
    public val isArchiveEnabled: Output<Boolean>? = null,
    public val logTemplate: Output<String>? = null,
    public val platform: Output<PlatformPropertiesArgs>,
    public val sourceLocation: Output<String>? = null,
    public val timeout: Output<Int>? = null,
    public val type: Output<String>,
    public val values: Output<List<SetValueArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.EncodedTaskRunRequestArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.EncodedTaskRunRequestArgs =
        com.pulumi.azurenative.containerregistry.inputs.EncodedTaskRunRequestArgs.builder()
            .agentConfiguration(
                agentConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .agentPoolName(agentPoolName?.applyValue({ args0 -> args0 }))
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encodedTaskContent(encodedTaskContent.applyValue({ args0 -> args0 }))
            .encodedValuesContent(encodedValuesContent?.applyValue({ args0 -> args0 }))
            .isArchiveEnabled(isArchiveEnabled?.applyValue({ args0 -> args0 }))
            .logTemplate(logTemplate?.applyValue({ args0 -> args0 }))
            .platform(platform.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceLocation(sourceLocation?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .values(
                values?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EncodedTaskRunRequestArgs].
 */
@PulumiTagMarker
public class EncodedTaskRunRequestArgsBuilder internal constructor() {
    private var agentConfiguration: Output<AgentPropertiesArgs>? = null

    private var agentPoolName: Output<String>? = null

    private var credentials: Output<CredentialsArgs>? = null

    private var encodedTaskContent: Output<String>? = null

    private var encodedValuesContent: Output<String>? = null

    private var isArchiveEnabled: Output<Boolean>? = null

    private var logTemplate: Output<String>? = null

    private var platform: Output<PlatformPropertiesArgs>? = null

    private var sourceLocation: Output<String>? = null

    private var timeout: Output<Int>? = null

    private var type: Output<String>? = null

    private var values: Output<List<SetValueArgs>>? = null

    /**
     * @param value The machine configuration of the run agent.
     */
    @JvmName("hjeecymqmvtkuinj")
    public suspend fun agentConfiguration(`value`: Output<AgentPropertiesArgs>) {
        this.agentConfiguration = value
    }

    /**
     * @param value The dedicated agent pool for the run.
     */
    @JvmName("isaljfdiywfqfehx")
    public suspend fun agentPoolName(`value`: Output<String>) {
        this.agentPoolName = value
    }

    /**
     * @param value The properties that describes a set of credentials that will be used when this run is invoked.
     */
    @JvmName("wgcgqijkvyoieiym")
    public suspend fun credentials(`value`: Output<CredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value Base64 encoded value of the template/definition file content.
     */
    @JvmName("qygsovgguqdkqqyl")
    public suspend fun encodedTaskContent(`value`: Output<String>) {
        this.encodedTaskContent = value
    }

    /**
     * @param value Base64 encoded value of the parameters/values file content.
     */
    @JvmName("anvebkmucbauuyyc")
    public suspend fun encodedValuesContent(`value`: Output<String>) {
        this.encodedValuesContent = value
    }

    /**
     * @param value The value that indicates whether archiving is enabled for the run or not.
     */
    @JvmName("cvrxkcppyfsfhiro")
    public suspend fun isArchiveEnabled(`value`: Output<Boolean>) {
        this.isArchiveEnabled = value
    }

    /**
     * @param value The template that describes the repository and tag information for run log artifact.
     */
    @JvmName("eiqbnrxxrhkniphr")
    public suspend fun logTemplate(`value`: Output<String>) {
        this.logTemplate = value
    }

    /**
     * @param value The platform properties against which the run has to happen.
     */
    @JvmName("kgjjfsujqgehitrb")
    public suspend fun platform(`value`: Output<PlatformPropertiesArgs>) {
        this.platform = value
    }

    /**
     * @param value The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
     * If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
     */
    @JvmName("cfehcndhadpkurdx")
    public suspend fun sourceLocation(`value`: Output<String>) {
        this.sourceLocation = value
    }

    /**
     * @param value Run timeout in seconds.
     */
    @JvmName("sitdljgkmmlwyotb")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value The type of the run request.
     * Expected value is 'EncodedTaskRunRequest'.
     */
    @JvmName("kwhxaxwheljddpvd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The collection of overridable values that can be passed when running a task.
     */
    @JvmName("ycuyaiusboedqkcd")
    public suspend fun values(`value`: Output<List<SetValueArgs>>) {
        this.values = value
    }

    @JvmName("csawdwouqbrqjban")
    public suspend fun values(vararg values: Output<SetValueArgs>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The collection of overridable values that can be passed when running a task.
     */
    @JvmName("stagcuxfebmtyioj")
    public suspend fun values(values: List<Output<SetValueArgs>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The machine configuration of the run agent.
     */
    @JvmName("dcupldrfldbrrlko")
    public suspend fun agentConfiguration(`value`: AgentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentConfiguration = mapped
    }

    /**
     * @param argument The machine configuration of the run agent.
     */
    @JvmName("ypjkytwhoibjjkrl")
    public suspend fun agentConfiguration(argument: suspend AgentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AgentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentConfiguration = mapped
    }

    /**
     * @param value The dedicated agent pool for the run.
     */
    @JvmName("venxufqtjrwpfphh")
    public suspend fun agentPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPoolName = mapped
    }

    /**
     * @param value The properties that describes a set of credentials that will be used when this run is invoked.
     */
    @JvmName("yuxrwtxauphvltcy")
    public suspend fun credentials(`value`: CredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument The properties that describes a set of credentials that will be used when this run is invoked.
     */
    @JvmName("mqjkcirnowskbidc")
    public suspend fun credentials(argument: suspend CredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value Base64 encoded value of the template/definition file content.
     */
    @JvmName("gdlaphibumwrloys")
    public suspend fun encodedTaskContent(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encodedTaskContent = mapped
    }

    /**
     * @param value Base64 encoded value of the parameters/values file content.
     */
    @JvmName("rxjcvtbwgjpkubpr")
    public suspend fun encodedValuesContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodedValuesContent = mapped
    }

    /**
     * @param value The value that indicates whether archiving is enabled for the run or not.
     */
    @JvmName("ijmcwhayumrwwgxi")
    public suspend fun isArchiveEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchiveEnabled = mapped
    }

    /**
     * @param value The template that describes the repository and tag information for run log artifact.
     */
    @JvmName("qjojocudximuawnf")
    public suspend fun logTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logTemplate = mapped
    }

    /**
     * @param value The platform properties against which the run has to happen.
     */
    @JvmName("twaivrwfiaeeynyp")
    public suspend fun platform(`value`: PlatformPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param argument The platform properties against which the run has to happen.
     */
    @JvmName("ldpvfbnxcktmsgxj")
    public suspend fun platform(argument: suspend PlatformPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PlatformPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.platform = mapped
    }

    /**
     * @param value The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
     * If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
     */
    @JvmName("etwsqnljmnexgntv")
    public suspend fun sourceLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceLocation = mapped
    }

    /**
     * @param value Run timeout in seconds.
     */
    @JvmName("soniaedtopvipkfr")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value The type of the run request.
     * Expected value is 'EncodedTaskRunRequest'.
     */
    @JvmName("onvurpvcuexbdvrh")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The collection of overridable values that can be passed when running a task.
     */
    @JvmName("ntcgscfmlryqookd")
    public suspend fun values(`value`: List<SetValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param argument The collection of overridable values that can be passed when running a task.
     */
    @JvmName("vtquoxqlldvlhabp")
    public suspend fun values(argument: List<suspend SetValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SetValueArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument The collection of overridable values that can be passed when running a task.
     */
    @JvmName("gpethihvmmflrftm")
    public suspend fun values(vararg argument: suspend SetValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SetValueArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument The collection of overridable values that can be passed when running a task.
     */
    @JvmName("yunwrpshsnoqlyno")
    public suspend fun values(argument: suspend SetValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SetValueArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param values The collection of overridable values that can be passed when running a task.
     */
    @JvmName("envubmgedfociiiw")
    public suspend fun values(vararg values: SetValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): EncodedTaskRunRequestArgs = EncodedTaskRunRequestArgs(
        agentConfiguration = agentConfiguration,
        agentPoolName = agentPoolName,
        credentials = credentials,
        encodedTaskContent = encodedTaskContent ?: throw PulumiNullFieldException("encodedTaskContent"),
        encodedValuesContent = encodedValuesContent,
        isArchiveEnabled = isArchiveEnabled,
        logTemplate = logTemplate,
        platform = platform ?: throw PulumiNullFieldException("platform"),
        sourceLocation = sourceLocation,
        timeout = timeout,
        type = type ?: throw PulumiNullFieldException("type"),
        values = values,
    )
}
